/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.elements;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.php.api.PhpVersion;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.api.QualifiedName;
import org.netbeans.modules.php.editor.api.elements.BaseFunctionElement;
import org.netbeans.modules.php.editor.api.elements.ParameterElement;
import org.netbeans.modules.php.editor.api.elements.TypeMemberElement;
import org.netbeans.modules.php.editor.api.elements.TypeNameResolver;
import org.netbeans.modules.php.editor.api.elements.TypeResolver;

public class BaseFunctionElementSupport {
    private final Parameters parameters;
    private final ReturnTypes returnTypes;

    protected BaseFunctionElementSupport(Parameters parameters, ReturnTypes returnTypes) {
        assert (parameters != null);
        assert (returnTypes != null);
        this.parameters = parameters;
        this.returnTypes = returnTypes;
    }

    public final List<ParameterElement> getParameters() {
        return this.parameters.getParameters();
    }

    public final Collection<TypeResolver> getReturnTypes() {
        return this.returnTypes.getReturnTypes();
    }

    public final String asString(BaseFunctionElement.PrintAs as, BaseFunctionElement element, TypeNameResolver typeNameResolver) {
        return this.asString(as, element, typeNameResolver, null);
    }

    public final String asString(BaseFunctionElement.PrintAs as, BaseFunctionElement element, TypeNameResolver typeNameResolver, @NullAllowed PhpVersion phpVersion) {
        StringBuilder template = new StringBuilder();
        switch (as) {
            case NameAndParamsDeclaration: {
                template.append(" ").append(element.getName()).append("(");
                template.append(BaseFunctionElementSupport.parameters2String(element, this.getParameters(), ParameterElement.OutputType.COMPLETE_DECLARATION, typeNameResolver));
                template.append(")");
                break;
            }
            case NameAndParamsInvocation: {
                template.append(" ").append(element.getName()).append("(");
                template.append(BaseFunctionElementSupport.parameters2String(element, this.getParameters(), ParameterElement.OutputType.SIMPLE_NAME, typeNameResolver));
                template.append(")");
                break;
            }
            case DeclarationWithoutBody: {
                String returnType;
                Collection<TypeResolver> returns1;
                String modifiers = element.getPhpModifiers().toString();
                if (modifiers.length() > 0) {
                    template.append(modifiers).append(" ");
                }
                template.append("function");
                template.append(this.asString(BaseFunctionElement.PrintAs.NameAndParamsDeclaration, element, typeNameResolver, phpVersion));
                if (phpVersion == null || phpVersion.compareTo((Enum)PhpVersion.PHP_70) < 0 || (returns1 = this.getReturnTypes()).size() != 1 || !StringUtils.hasText((String)(returnType = this.asString(BaseFunctionElement.PrintAs.ReturnTypes, element, typeNameResolver, phpVersion)))) break;
                boolean isNullableType = CodeUtils.isNullableType(returnType);
                if (isNullableType) {
                    returnType = returnType.substring(1);
                }
                if ("\\self".equals(returnType) && element instanceof TypeMemberElement) {
                    returnType = ((TypeMemberElement)((Object)element)).getType().getFullyQualifiedName().toString();
                }
                template.append(": ");
                if (isNullableType) {
                    template.append("?");
                }
                template.append(returnType);
                break;
            }
            case DeclarationWithEmptyBody: {
                template.append(this.asString(BaseFunctionElement.PrintAs.DeclarationWithoutBody, element, typeNameResolver, phpVersion));
                template.append("{\n}");
                break;
            }
            case DeclarationWithParentCallInBody: {
                template.append(this.asString(BaseFunctionElement.PrintAs.DeclarationWithoutBody, element, typeNameResolver, phpVersion));
                Collection<TypeResolver> returns2 = this.getReturnTypes();
                String methdodInvocation = this.asString(BaseFunctionElement.PrintAs.NameAndParamsInvocation, element, typeNameResolver, phpVersion);
                if (methdodInvocation.startsWith(" ")) {
                    methdodInvocation = methdodInvocation.substring(1);
                }
                if (returns2.size() > 0) {
                    template.append(String.format("{%nreturn parent::%s;%n}", methdodInvocation));
                    break;
                }
                template.append(String.format("{%nparent::%s;%n}", methdodInvocation));
                break;
            }
            case ReturnSemiTypes: {
                for (TypeResolver typeResolver : this.getReturnTypes()) {
                    Object typeName;
                    if (typeResolver.isResolved()) {
                        typeName = typeResolver.getTypeName(false);
                        if (typeName == null) continue;
                        if (template.length() > 0) {
                            template.append("|");
                        }
                        template.append(typeNameResolver.resolve((QualifiedName)typeName).toString());
                        continue;
                    }
                    typeName = typeResolver.getRawTypeName();
                    if (typeName == null) continue;
                    if (template.length() > 0) {
                        template.append("|");
                    }
                    template.append((String)typeName);
                }
                break;
            }
            case ReturnTypes: {
                for (TypeResolver typeResolver : this.getReturnTypes()) {
                    QualifiedName typeName;
                    if (!typeResolver.isResolved() || (typeName = typeResolver.getTypeName(false)) == null) continue;
                    if (template.length() > 0) {
                        template.append("|");
                    }
                    if (typeResolver.isNullableType()) {
                        template.append("?");
                    }
                    template.append(typeNameResolver.resolve(typeName).toString());
                }
                break;
            }
            default: {
                assert (false) : as;
                break;
            }
        }
        return template.toString();
    }

    private static String parameters2String(BaseFunctionElement element, List<ParameterElement> parameterList, ParameterElement.OutputType stringOutputType, TypeNameResolver typeNameResolver) {
        StringBuilder template = new StringBuilder();
        if (parameterList.size() > 0) {
            int n = parameterList.size();
            for (int i = 0; i < n; ++i) {
                ParameterElement param;
                String paramInfo;
                boolean isNullableType;
                StringBuilder paramSb = new StringBuilder();
                if (i > 0) {
                    paramSb.append(", ");
                }
                if (isNullableType = CodeUtils.isNullableType(paramInfo = (param = parameterList.get(i)).asString(stringOutputType, typeNameResolver))) {
                    paramInfo = paramInfo.substring(1);
                }
                if (paramInfo.startsWith("self ") && element instanceof TypeMemberElement) {
                    paramInfo = ((TypeMemberElement)((Object)element)).getType().getFullyQualifiedName().toString() + paramInfo.substring(4);
                }
                if (isNullableType) {
                    paramSb.append("?");
                }
                paramSb.append(paramInfo);
                template.append((CharSequence)paramSb);
            }
        }
        return template.toString();
    }

    public static final class ReturnTypesImpl
    implements ReturnTypes {
        private final Set<TypeResolver> returnTypes;

        public static ReturnTypes create(Set<TypeResolver> returnTypes) {
            return new ReturnTypesImpl(returnTypes);
        }

        private ReturnTypesImpl(Set<TypeResolver> returnTypes) {
            this.returnTypes = returnTypes;
        }

        @Override
        public Set<TypeResolver> getReturnTypes() {
            return Collections.unmodifiableSet(this.returnTypes);
        }
    }

    public static interface ReturnTypes {
        public static final ReturnTypes NONE = new ReturnTypes(){

            @Override
            public Set<TypeResolver> getReturnTypes() {
                return Collections.emptySet();
            }
        };

        public Set<TypeResolver> getReturnTypes();
    }

    public static final class ParametersImpl
    implements Parameters {
        private final List<ParameterElement> parameters;

        public static Parameters create(List<ParameterElement> parameters) {
            return new ParametersImpl(parameters);
        }

        private ParametersImpl(List<ParameterElement> parameters) {
            this.parameters = parameters;
        }

        @Override
        public List<ParameterElement> getParameters() {
            return this.parameters;
        }
    }

    public static interface Parameters {
        public List<ParameterElement> getParameters();
    }
}

