/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.DynamicHunspellLanguage;
import org.languagetool.DynamicLanguage;
import org.languagetool.DynamicMorfologikLanguage;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.Premium;
import org.languagetool.noop.NoopLanguage;
import org.languagetool.tools.MultiKeyProperties;
import org.languagetool.tools.StringTools;

public final class Languages {
    private static final String PROPERTIES_PATH = "META-INF/org/languagetool/language-module.properties";
    private static final String PROPERTIES_KEY = "languageClasses";
    private static final Language NOOP_LANGUAGE = new NoopLanguage();
    private static final List<Language> languages = Languages.getAllLanguages();
    private static final List<Language> dynLanguages = new ArrayList<Language>();

    private Languages() {
    }

    public static Language addLanguage(String name, String code, File dictPath) {
        DynamicLanguage lang;
        if (dictPath.getName().endsWith(".dict")) {
            lang = new DynamicMorfologikLanguage(name, code, dictPath);
        } else if (dictPath.getName().endsWith(".dic")) {
            lang = new DynamicHunspellLanguage(name, code, dictPath);
        } else {
            throw new RuntimeException("Please specify a dictPath that ends in '.dict' (Morfologik binary dictionary) or '.dic' (Hunspell dictionary): " + dictPath);
        }
        dynLanguages.add(lang);
        return lang;
    }

    public static List<Language> get() {
        ArrayList<Language> result = new ArrayList<Language>();
        for (Language lang : Languages.getStaticAndDynamicLanguages()) {
            if ("xx".equals(lang.getShortCode()) || "zz".equals(lang.getShortCode())) continue;
            result.add(lang);
        }
        return Collections.unmodifiableList(result);
    }

    public static List<Language> getWithDemoLanguage() {
        return Collections.unmodifiableList(Languages.getStaticAndDynamicLanguages());
    }

    private static List<Language> getStaticAndDynamicLanguages() {
        return Stream.concat(languages.stream(), dynLanguages.stream()).collect(Collectors.toList());
    }

    private static List<Language> getAllLanguages() {
        ArrayList<Language> languages = new ArrayList<Language>();
        HashSet<String> languageClassNames = new HashSet<String>();
        try {
            Enumeration<URL> propertyFiles = Language.class.getClassLoader().getResources(PROPERTIES_PATH);
            while (propertyFiles.hasMoreElements()) {
                URL url = propertyFiles.nextElement();
                InputStream inputStream = url.openStream();
                Throwable throwable = null;
                try {
                    MultiKeyProperties props = new MultiKeyProperties(inputStream);
                    List<String> classNamesStr = props.getProperty(PROPERTIES_KEY);
                    if (classNamesStr == null) {
                        throw new RuntimeException("Key 'languageClasses' not found in " + url);
                    }
                    for (String classNames : classNamesStr) {
                        String[] classNamesSplit;
                        for (String className : classNamesSplit = classNames.split("\\s*,\\s*")) {
                            if (languageClassNames.contains(className)) continue;
                            languages.add(Languages.createLanguageObjects(url, className));
                            languageClassNames.add(className);
                        }
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (inputStream == null) continue;
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    inputStream.close();
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return Collections.unmodifiableList(languages);
    }

    private static Language createLanguageObjects(URL url, String className) {
        try {
            if (Premium.isPremiumVersion() && Languages.hasPremium(className)) {
                className = className + "Premium";
            }
            Class<?> aClass = JLanguageTool.getClassBroker().forName(className);
            Constructor<?> constructor = aClass.getConstructor(new Class[0]);
            return (Language)constructor.newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Class '" + className + "' specified in " + url + " could not be found in classpath", e);
        }
        catch (Exception e) {
            throw new RuntimeException("Object for class '" + className + "' specified in " + url + " could not be created", e);
        }
    }

    static boolean hasPremium(String className) {
        return className.matches("org\\.languagetool\\.language\\.(Portuguese|AngolaPortuguese|BrazilianPortuguese|MozambiquePortuguese|PortugalPortuguese|German|GermanyGerman|AustrianGerman|SwissGerman|Dutch|French|Spanish|English|AustralianEnglish|AmericanEnglish|BritishEnglish|CanadianEnglish|NewZealandEnglish|SouthAfricanEnglish)");
    }

    public static Language getOrAddLanguageByClassName(String className) {
        for (Language element : Languages.getStaticAndDynamicLanguages()) {
            if (!className.equals(element.getClass().getName())) continue;
            return element;
        }
        try {
            Class<?> aClass = JLanguageTool.getClassBroker().forName(className);
            Constructor<?> constructor = aClass.getConstructor(new Class[0]);
            Language language = (Language)constructor.newInstance(new Object[0]);
            dynLanguages.add(language);
            return language;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Class '" + className + " could not be found in classpath", e);
        }
        catch (Exception e) {
            throw new RuntimeException("Object for class '" + className + " could not be created", e);
        }
    }

    @Nullable
    public static Language getLanguageForName(String languageName) {
        for (Language element : Languages.getStaticAndDynamicLanguages()) {
            if (!languageName.equals(element.getName())) continue;
            return element;
        }
        return null;
    }

    public static Language getLanguageForShortCode(String langCode) {
        return Languages.getLanguageForShortCode(langCode, Collections.emptyList());
    }

    public static Language getLanguageForShortCode(String langCode, List<String> noopLanguageCodes) {
        Language language = Languages.getLanguageForShortCodeOrNull(langCode);
        if (language == null) {
            language = Languages.getLongCodeToLangMapping().get(langCode);
        }
        if (language == null) {
            if (noopLanguageCodes.contains(langCode)) {
                return NOOP_LANGUAGE;
            }
            throw new IllegalArgumentException("'" + langCode + "' is not a language code known to LanguageTool. Supported language codes are: " + String.join((CharSequence)", ", Languages.getLangCodes()) + ". The list of languages is read from " + PROPERTIES_PATH + " in the Java classpath. See https://dev.languagetool.org/java-api for details.");
        }
        return language;
    }

    @NotNull
    private static List<String> getLangCodes() {
        ArrayList<String> codes = new ArrayList<String>();
        for (Language realLanguage : Languages.getStaticAndDynamicLanguages()) {
            codes.add(realLanguage.getShortCodeWithCountryAndVariant());
        }
        Map<String, Language> longCodeToLang = Languages.getLongCodeToLangMapping();
        for (Map.Entry<String, Language> entry : longCodeToLang.entrySet()) {
            if (codes.contains(entry.getKey())) continue;
            codes.add(entry.getKey());
        }
        Collections.sort(codes);
        return codes;
    }

    public static boolean isLanguageSupported(String langCode) {
        return Languages.getLanguageForShortCodeOrNull(langCode) != null;
    }

    public static Language getLanguageForLocale(Locale locale) {
        Language language = Languages.getLanguageForLanguageNameAndCountry(locale);
        if (language != null) {
            return language;
        }
        Language firstFallbackLanguage = Languages.getLanguageForLanguageNameOnly(locale);
        if (firstFallbackLanguage != null) {
            return firstFallbackLanguage;
        }
        for (Language aLanguage : languages) {
            if (!aLanguage.getShortCodeWithCountryAndVariant().equals("en-US")) continue;
            return aLanguage;
        }
        throw new RuntimeException("No appropriate language found, not even en-US. Supported languages: " + Languages.get());
    }

    public static Map<String, Language> getLongCodeToLangMapping() {
        HashMap<String, Language> map = new HashMap<String, Language>();
        List<Language> languages = Languages.get();
        for (Language language : languages) {
            if (language.getCountries().length <= 0 || language.getCountries()[0].isEmpty()) continue;
            map.put(language.getShortCode() + "-" + language.getCountries()[0], language);
        }
        return map;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    private static Language getLanguageForShortCodeOrNull(String langCode) {
        Language element;
        StringTools.assureSet(langCode, "langCode");
        Language result = null;
        if (langCode.contains("-x-")) {
            Language element2;
            Iterator<Language> iterator = Languages.getStaticAndDynamicLanguages().iterator();
            do {
                if (!iterator.hasNext()) return result;
            } while (!(element2 = iterator.next()).getShortCode().equalsIgnoreCase(langCode));
            return element2;
        }
        if (langCode.contains("-")) {
            Language element3;
            String[] parts = langCode.split("-");
            if (parts.length == 2) {
                Language element4;
                Iterator<Language> element2 = Languages.getStaticAndDynamicLanguages().iterator();
                do {
                    if (!element2.hasNext()) return result;
                } while (!parts[0].equalsIgnoreCase((element4 = element2.next()).getShortCode()) || element4.getCountries().length != 1 || !parts[1].equalsIgnoreCase(element4.getCountries()[0]));
                return element4;
            }
            if (parts.length != 3) throw new IllegalArgumentException("'" + langCode + "' isn't a valid language code");
            Iterator<Language> element2 = Languages.getStaticAndDynamicLanguages().iterator();
            do {
                if (!element2.hasNext()) return result;
            } while (!parts[0].equalsIgnoreCase((element3 = element2.next()).getShortCode()) || element3.getCountries().length != 1 || !parts[1].equalsIgnoreCase(element3.getCountries()[0]) || !parts[2].equalsIgnoreCase(element3.getVariant()));
            return element3;
        }
        Iterator<Language> iterator = Languages.getStaticAndDynamicLanguages().iterator();
        do {
            if (!iterator.hasNext()) return result;
            element = iterator.next();
            if (!langCode.equals("global")) continue;
            return element;
        } while (!langCode.equalsIgnoreCase(element.getShortCode()));
        return element;
    }

    @Nullable
    private static Language getLanguageForLanguageNameAndCountry(Locale locale) {
        for (Language language : Languages.getStaticAndDynamicLanguages()) {
            List<String> countryVariants;
            if (!language.getShortCode().equals(locale.getLanguage()) || !(countryVariants = Arrays.asList(language.getCountries())).contains(locale.getCountry())) continue;
            return language;
        }
        return null;
    }

    @Nullable
    private static Language getLanguageForLanguageNameOnly(Locale locale) {
        for (Language language : Languages.getStaticAndDynamicLanguages()) {
            Language defaultVariant;
            if (!language.getShortCode().equals(locale.getLanguage()) || !language.hasVariant() || (defaultVariant = language.getDefaultLanguageVariant()) == null) continue;
            return defaultVariant;
        }
        for (Language language : Languages.getStaticAndDynamicLanguages()) {
            if (!language.getShortCode().equals(locale.getLanguage()) || language.hasVariant()) continue;
            return language;
        }
        return null;
    }
}

