/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.seg.NShort.Path;

import com.hankcs.hanlp.seg.NShort.Path.CQueue;
import com.hankcs.hanlp.seg.NShort.Path.PathNode;
import com.hankcs.hanlp.seg.NShort.Path.QueueElement;
import com.hankcs.hanlp.seg.common.EdgeFrom;
import com.hankcs.hanlp.seg.common.Graph;
import com.hankcs.hanlp.utility.Predefine;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class NShortPath {
    private Graph graph;
    private int N;
    private int vertexCount;
    private CQueue[][] fromArray;
    private double[][] weightArray;

    public NShortPath(Graph graph, int N) {
        this.calculate(graph, N);
    }

    private void initNShortPath(Graph inGraph, int nValueKind) {
        this.graph = inGraph;
        this.N = nValueKind;
        this.vertexCount = inGraph.vertexes.length;
        this.fromArray = new CQueue[this.vertexCount - 1][];
        this.weightArray = new double[this.vertexCount - 1][];
        for (int i = 0; i < this.vertexCount - 1; ++i) {
            this.fromArray[i] = new CQueue[nValueKind];
            this.weightArray[i] = new double[nValueKind];
            for (int j = 0; j < nValueKind; ++j) {
                this.fromArray[i][j] = new CQueue();
            }
        }
    }

    private void calculate(Graph inGraph, int nValueKind) {
        this.initNShortPath(inGraph, nValueKind);
        CQueue queWork = new CQueue();
        for (int nCurNode = 1; nCurNode < this.vertexCount; ++nCurNode) {
            int i;
            this.enQueueCurNodeEdges(queWork, nCurNode);
            for (i = 0; i < this.N; ++i) {
                this.weightArray[nCurNode - 1][i] = Double.MAX_VALUE;
            }
            QueueElement tmpElement = queWork.deQueue();
            if (tmpElement == null) continue;
            block2: for (i = 0; i < this.N; ++i) {
                double eWeight;
                this.weightArray[nCurNode - 1][i] = eWeight = tmpElement.weight;
                do {
                    this.fromArray[nCurNode - 1][i].enQueue(new QueueElement(tmpElement.from, tmpElement.index, 0.0));
                    tmpElement = queWork.deQueue();
                    if (tmpElement != null) continue;
                    i = this.N;
                    continue block2;
                } while (tmpElement.weight == eWeight);
            }
        }
    }

    private void enQueueCurNodeEdges(CQueue queWork, int nCurNode) {
        queWork.clear();
        List<EdgeFrom> pEdgeToList = this.graph.getEdgeListTo(nCurNode);
        block0: for (EdgeFrom e : pEdgeToList) {
            int nPreNode = e.from;
            double eWeight = e.weight;
            for (int i = 0; i < this.N; ++i) {
                if (nPreNode == 0) {
                    queWork.enQueue(new QueueElement(nPreNode, i, eWeight));
                    continue block0;
                }
                if (this.weightArray[nPreNode - 1][i] == Double.MAX_VALUE) continue block0;
                queWork.enQueue(new QueueElement(nPreNode, i, eWeight + this.weightArray[nPreNode - 1][i]));
            }
        }
    }

    public List<int[]> getPaths(int index) {
        assert (index <= this.N && index >= 0);
        Stack<PathNode> stack = new Stack<PathNode>();
        int curNode = this.vertexCount - 1;
        int curIndex = index;
        ArrayList<int[]> result = new ArrayList<int[]>();
        QueueElement element = this.fromArray[curNode - 1][curIndex].GetFirst();
        while (element != null) {
            int i;
            stack.push(new PathNode(curNode, curIndex));
            stack.push(new PathNode(element.from, element.index));
            curNode = element.from;
            while (curNode != 0) {
                element = this.fromArray[element.from - 1][element.index].GetFirst();
                stack.push(new PathNode(element.from, element.index));
                curNode = element.from;
            }
            PathNode[] nArray = new PathNode[stack.size()];
            for (i = 0; i < stack.size(); ++i) {
                nArray[i] = (PathNode)stack.get(stack.size() - i - 1);
            }
            int[] aPath = new int[nArray.length];
            for (i = 0; i < aPath.length; ++i) {
                aPath[i] = nArray[i].from;
            }
            result.add(aPath);
            do {
                PathNode node = (PathNode)stack.pop();
                curNode = node.from;
                curIndex = node.index;
            } while (curNode < 1 || stack.size() != 0 && !this.fromArray[curNode - 1][curIndex].CanGetNext());
            element = this.fromArray[curNode - 1][curIndex].GetNext();
        }
        return result;
    }

    public Integer[] getBestPath() {
        assert (this.vertexCount > 2);
        Stack<Integer> stack = new Stack<Integer>();
        int curNode = this.vertexCount - 1;
        int curIndex = 0;
        QueueElement element = this.fromArray[curNode - 1][curIndex].GetFirst();
        stack.push(curNode);
        stack.push(element.from);
        curNode = element.from;
        while (curNode != 0) {
            element = this.fromArray[element.from - 1][element.index].GetFirst();
            stack.push(element.from);
            curNode = element.from;
        }
        return (Integer[])stack.toArray();
    }

    public List<int[]> getNPaths(int n) {
        ArrayList<int[]> result = new ArrayList<int[]>();
        n = Math.min(Predefine.MAX_SEGMENT_NUM, n);
        block0: for (int i = 0; i < this.N && result.size() < n; ++i) {
            List<int[]> pathList = this.getPaths(i);
            for (int[] path : pathList) {
                if (result.size() == n) continue block0;
                result.add(path);
            }
        }
        return result;
    }

    public List<int[]> getNPaths() {
        return this.getNPaths(Predefine.MAX_SEGMENT_NUM);
    }
}

