/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.dependency.perceptron.transition.parser;

import com.hankcs.hanlp.dependency.perceptron.learning.AveragedPerceptron;
import com.hankcs.hanlp.dependency.perceptron.transition.configuration.BeamElement;
import com.hankcs.hanlp.dependency.perceptron.transition.configuration.Configuration;
import com.hankcs.hanlp.dependency.perceptron.transition.configuration.State;
import com.hankcs.hanlp.dependency.perceptron.transition.features.FeatureExtractor;
import com.hankcs.hanlp.dependency.perceptron.transition.parser.Action;
import com.hankcs.hanlp.dependency.perceptron.transition.parser.ArcEager;
import com.hankcs.hanlp.dependency.perceptron.transition.parser.PartialTreeBeamScorerThread;
import java.util.ArrayList;
import java.util.concurrent.Callable;

public class BeamScorerThread
implements Callable<ArrayList<BeamElement>> {
    boolean isDecode;
    AveragedPerceptron classifier;
    Configuration configuration;
    ArrayList<Integer> dependencyRelations;
    int featureLength;
    int b;
    boolean rootFirst;

    public BeamScorerThread(boolean isDecode, AveragedPerceptron classifier, Configuration configuration, ArrayList<Integer> dependencyRelations, int featureLength, int b, boolean rootFirst) {
        this.isDecode = isDecode;
        this.classifier = classifier;
        this.configuration = configuration;
        this.dependencyRelations = dependencyRelations;
        this.featureLength = featureLength;
        this.b = b;
        this.rootFirst = rootFirst;
    }

    @Override
    public ArrayList<BeamElement> call() {
        ArrayList<BeamElement> elements = new ArrayList<BeamElement>(this.dependencyRelations.size() * 2 + 3);
        State currentState = this.configuration.state;
        float prevScore = this.configuration.score;
        boolean canShift = ArcEager.canDo(Action.Shift, currentState);
        boolean canReduce = ArcEager.canDo(Action.Reduce, currentState);
        boolean canRightArc = ArcEager.canDo(Action.RightArc, currentState);
        boolean canLeftArc = ArcEager.canDo(Action.LeftArc, currentState);
        Object[] features = FeatureExtractor.extractAllParseFeatures(this.configuration, this.featureLength);
        PartialTreeBeamScorerThread.addAvailableBeamElements(elements, prevScore, canShift, canReduce, canRightArc, canLeftArc, features, this.classifier, this.isDecode, this.b, this.dependencyRelations);
        return elements;
    }
}

