/*
 * Decompiled with CFR 0.152.
 */
package org.bridj.util;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.bridj.BridJ;
import org.bridj.Platform;
import org.bridj.util.BytecodeAnalyzer;
import org.bridj.util.StringUtils;

public class JNIUtils {
    private static Map<String, NativeMethodsCache> nativeMethodsCache = new WeakHashMap<String, NativeMethodsCache>();
    private static final String bridjPackage = BridJ.class.getPackage() == null ? "org.bridj" : BridJ.class.getPackage().getName();
    private static final String bridjNormalPackagePrefix = bridjPackage.endsWith("v0_7_0") ? bridjPackage.substring(0, bridjPackage.length() - "v0_7_0".length()) : bridjPackage + ".";
    private static final String bridjVersionSpecificPackagePrefix = bridjPackage + ".";

    private static synchronized NativeMethodsCache getNativeMethodsCache(String internalClassName) throws IOException {
        NativeMethodsCache cache = nativeMethodsCache.get(internalClassName);
        if (cache == null) {
            cache = new NativeMethodsCache(internalClassName);
            nativeMethodsCache.put(internalClassName, cache);
        }
        return cache;
    }

    static int findLastNonEscapeUnderscore(String s) {
        int len;
        int i = len = s.length();
        do {
            if ((i = s.lastIndexOf("_", i - 1)) < 0 || i != len - 1 && Character.isDigit(s.charAt(i + 1))) continue;
            return i;
        } while (i > 0);
        return -1;
    }

    public static String decodeVersionSpecificMethodNameClassAndSignature(String symbolName, Object[] nameAndSigArray) throws NoSuchMethodException, IOException {
        return JNIUtils.decodeMethodNameClassAndSignature(symbolName, nameAndSigArray, bridjNormalPackagePrefix, bridjVersionSpecificPackagePrefix);
    }

    static String decodeMethodNameClassAndSignature(String symbolName, Object[] nameAndSigArray, String normalClassPrefix, String replacementClassPrefix) throws NoSuchMethodException, IOException {
        if (symbolName.startsWith("_")) {
            symbolName = symbolName.substring(1);
        }
        if (symbolName.startsWith("Java_")) {
            symbolName = symbolName.substring("Java_".length());
        }
        int i = JNIUtils.findLastNonEscapeUnderscore(symbolName);
        String className = symbolName.substring(0, i).replace('_', '.');
        if (normalClassPrefix != null && className.startsWith(normalClassPrefix) && !className.startsWith(replacementClassPrefix)) {
            className = replacementClassPrefix + className.substring(normalClassPrefix.length());
        }
        String methodName = symbolName.substring(i + 1).replaceAll("_1", "_");
        NativeMethodsCache mc = JNIUtils.getNativeMethodsCache(className.replace('.', '/'));
        String sig = mc.get(methodName);
        if (sig == null) {
            throw new NoSuchMethodException("Method " + methodName + " not found in class " + className + " : known method names = " + StringUtils.implode(mc.getNames(), (Object)", "));
        }
        nameAndSigArray[0] = methodName;
        nameAndSigArray[1] = sig;
        String internalClassName = className.replace('.', '/');
        return internalClassName;
    }

    public static String getNativeName(Class c) {
        return c.getName().replace('.', '/');
    }

    public static String getNativeSignature(Method m) {
        StringBuffer b = new StringBuffer();
        b.append('(');
        for (Class<?> c : m.getParameterTypes()) {
            b.append(JNIUtils.getNativeSignature(c));
        }
        b.append(')');
        b.append(JNIUtils.getNativeSignature(m.getReturnType()));
        return b.toString();
    }

    public static String getNativeSignature(Class c) {
        if (c.isPrimitive()) {
            if (c == Integer.TYPE) {
                return "I";
            }
            if (c == Long.TYPE) {
                return "J";
            }
            if (c == Short.TYPE) {
                return "S";
            }
            if (c == Byte.TYPE) {
                return "B";
            }
            if (c == Boolean.TYPE) {
                return "Z";
            }
            if (c == Double.TYPE) {
                return "D";
            }
            if (c == Float.TYPE) {
                return "F";
            }
            if (c == Character.TYPE) {
                return "C";
            }
            if (c == Void.TYPE) {
                return "V";
            }
            throw new RuntimeException("unexpected case");
        }
        if (c.isArray()) {
            return "[" + JNIUtils.getNativeSignature(c.getComponentType());
        }
        return "L" + JNIUtils.getNativeName(c) + ";";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NativeMethodsCache {
        Map<String, String> signatures = new HashMap<String, String>();

        public NativeMethodsCache(String internalClassName) throws IOException {
            for (String[] sig : BytecodeAnalyzer.getNativeMethodSignatures(internalClassName, Platform.getClassLoader())) {
                this.signatures.put(sig[1], sig[2]);
            }
        }

        public String get(String name) {
            return this.signatures.get(name);
        }

        public Set<String> getNames() {
            return this.signatures.keySet();
        }
    }
}

