/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListSelectionModel;
import javax.swing.DropMode;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.openstreetmap.josm.actions.ExpertToggleAction;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.imagery.OffsetBookmark;
import org.openstreetmap.josm.data.preferences.AbstractProperty;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.IEnabledStateUpdating;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.dialogs.layer.ActivateLayerAction;
import org.openstreetmap.josm.gui.dialogs.layer.CycleLayerDownAction;
import org.openstreetmap.josm.gui.dialogs.layer.CycleLayerUpAction;
import org.openstreetmap.josm.gui.dialogs.layer.DeleteLayerAction;
import org.openstreetmap.josm.gui.dialogs.layer.DuplicateAction;
import org.openstreetmap.josm.gui.dialogs.layer.LayerListTransferHandler;
import org.openstreetmap.josm.gui.dialogs.layer.LayerVisibilityAction;
import org.openstreetmap.josm.gui.dialogs.layer.MergeAction;
import org.openstreetmap.josm.gui.dialogs.layer.MoveDownAction;
import org.openstreetmap.josm.gui.dialogs.layer.MoveUpAction;
import org.openstreetmap.josm.gui.dialogs.layer.ShowHideLayerAction;
import org.openstreetmap.josm.gui.layer.AbstractTileSourceLayer;
import org.openstreetmap.josm.gui.layer.JumpToMarkerActions;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.LayerManager;
import org.openstreetmap.josm.gui.layer.MainLayerManager;
import org.openstreetmap.josm.gui.layer.NativeScaleLayer;
import org.openstreetmap.josm.gui.layer.imagery.TileSourceDisplaySettings;
import org.openstreetmap.josm.gui.util.MultikeyActionsHandler;
import org.openstreetmap.josm.gui.util.MultikeyShortcutAction;
import org.openstreetmap.josm.gui.util.ReorderableTableModel;
import org.openstreetmap.josm.gui.util.TableHelper;
import org.openstreetmap.josm.gui.widgets.DisableShortcutsOnFocusGainedTextField;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.gui.widgets.PopupMenuLauncher;
import org.openstreetmap.josm.gui.widgets.ScrollableTable;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.ArrayUtils;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.InputMapUtils;
import org.openstreetmap.josm.tools.PlatformManager;
import org.openstreetmap.josm.tools.Shortcut;

public class LayerListDialog
extends ToggleDialog
implements TileSourceDisplaySettings.DisplaySettingsChangeListener {
    private static volatile LayerListDialog instance;
    private static final BooleanProperty DISPLAY_NUMBERS;
    private final LayerListModel model;
    private final LayerList layerList;
    private final ColumnWidthAdaptionListener visibilityWidthListener;
    private final ActivateLayerAction activateLayerAction;
    private final ShowHideLayerAction showHideLayerAction;
    private final CycleLayerUpAction cycleLayerUpAction;
    private final CycleLayerDownAction cycleLayerDownAction;
    private final transient Shortcut[] visibilityToggleShortcuts = new Shortcut[10];
    private final ToggleLayerIndexVisibility[] visibilityToggleActions = new ToggleLayerIndexVisibility[10];
    private final transient MainLayerManager layerManager;

    public static void createInstance(MainLayerManager layerManager) {
        if (instance != null) {
            throw new IllegalStateException("Dialog was already created");
        }
        instance = new LayerListDialog(layerManager);
    }

    public static LayerListDialog getInstance() {
        if (instance == null) {
            throw new IllegalStateException("Dialog not created yet. Invoke createInstance() first");
        }
        return instance;
    }

    private void createVisibilityToggleShortcuts() {
        for (int i = 0; i < 10; ++i) {
            int i1 = i + 1;
            this.visibilityToggleShortcuts[i] = Shortcut.registerShortcut("subwindow:layers:toggleLayer" + i1, I18n.tr("Toggle visibility of layer: {0}", i1), 48 + i1 % 10, 5004);
            this.visibilityToggleActions[i] = new ToggleLayerIndexVisibility(i);
            MainApplication.registerActionShortcut(this.visibilityToggleActions[i], this.visibilityToggleShortcuts[i]);
        }
    }

    public LayerListDialog(MainLayerManager layerManager) {
        super(I18n.tr("Layers", new Object[0]), "layerlist", I18n.tr("Open a list of all loaded layers.", new Object[0]), Shortcut.registerShortcut("subwindow:layers", I18n.tr("Windows: {0}", I18n.tr("Layers", new Object[0])), 76, 5007), 100, true);
        this.layerManager = layerManager;
        DefaultListSelectionModel selectionModel = new DefaultListSelectionModel();
        selectionModel.setSelectionMode(2);
        this.model = new LayerListModel(layerManager, selectionModel);
        this.layerList = new LayerList(this.model);
        TableHelper.setFont(this.layerList, this.getClass());
        this.layerList.setSelectionModel(selectionModel);
        this.layerList.addMouseListener(new PopupMenuHandler());
        this.layerList.setBackground(UIManager.getColor("Button.background"));
        this.layerList.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.layerList.putClientProperty("JTable.autoStartsEdit", Boolean.FALSE);
        this.layerList.setSelectionMode(2);
        this.layerList.setTableHeader(null);
        this.layerList.setShowGrid(false);
        this.layerList.setIntercellSpacing(new Dimension(0, 0));
        this.layerList.getColumnModel().getColumn(0).setCellRenderer(new ActiveLayerCellRenderer());
        this.layerList.getColumnModel().getColumn(0).setCellEditor(new DefaultCellEditor(new ActiveLayerCheckBox()));
        this.layerList.getColumnModel().getColumn(0).setMaxWidth(12);
        this.layerList.getColumnModel().getColumn(0).setPreferredWidth(12);
        this.layerList.getColumnModel().getColumn(0).setResizable(false);
        this.layerList.getColumnModel().getColumn(1).setCellRenderer(new NativeScaleLayerCellRenderer());
        this.layerList.getColumnModel().getColumn(1).setCellEditor(new DefaultCellEditor(new NativeScaleLayerCheckBox()));
        this.layerList.getColumnModel().getColumn(1).setMaxWidth(12);
        this.layerList.getColumnModel().getColumn(1).setPreferredWidth(12);
        this.layerList.getColumnModel().getColumn(1).setResizable(false);
        this.layerList.getColumnModel().getColumn(2).setCellRenderer(new OffsetLayerCellRenderer());
        this.layerList.getColumnModel().getColumn(2).setCellEditor(new DefaultCellEditor(new OffsetLayerCheckBox()));
        this.layerList.getColumnModel().getColumn(2).setMaxWidth(16);
        this.layerList.getColumnModel().getColumn(2).setPreferredWidth(16);
        this.layerList.getColumnModel().getColumn(2).setResizable(false);
        this.layerList.getColumnModel().getColumn(3).setCellRenderer(new LayerVisibleCellRenderer());
        this.layerList.getColumnModel().getColumn(3).setCellEditor(new LayerVisibleCellEditor(new LayerVisibleCheckBox()));
        this.layerList.getColumnModel().getColumn(3).setResizable(false);
        this.layerList.getColumnModel().getColumn(4).setCellRenderer(new LayerNameCellRenderer());
        this.layerList.getColumnModel().getColumn(4).setCellEditor(new LayerNameCellEditor(new DisableShortcutsOnFocusGainedTextField()));
        for (KeyStroke ks : new KeyStroke[]{KeyStroke.getKeyStroke(67, PlatformManager.getPlatform().getMenuShortcutKeyMaskEx()), KeyStroke.getKeyStroke(86, PlatformManager.getPlatform().getMenuShortcutKeyMaskEx()), KeyStroke.getKeyStroke(40, 64), KeyStroke.getKeyStroke(38, 64), KeyStroke.getKeyStroke(37, 64), KeyStroke.getKeyStroke(39, 64), KeyStroke.getKeyStroke(40, 128), KeyStroke.getKeyStroke(38, 128), KeyStroke.getKeyStroke(37, 128), KeyStroke.getKeyStroke(39, 128), KeyStroke.getKeyStroke(33, 0), KeyStroke.getKeyStroke(34, 0), KeyStroke.getKeyStroke(9, 0), KeyStroke.getKeyStroke(119, 0)}) {
            this.layerList.getInputMap(1).put(ks, new Object());
        }
        this.visibilityWidthListener = new ColumnWidthAdaptionListener(3, 16);
        DISPLAY_NUMBERS.addListener(this.visibilityWidthListener);
        ExpertToggleAction.addExpertModeChangeListener(this.visibilityWidthListener);
        layerManager.addLayerChangeListener(this.visibilityWidthListener);
        this.visibilityWidthListener.updateColumnWidth();
        this.model.populate();
        this.model.setSelectedLayer(layerManager.getActiveLayer());
        this.model.addLayerListModelListener(new LayerListModelListener(){

            @Override
            public void makeVisible(int row, Layer layer) {
                LayerListDialog.this.layerList.scrollToVisible(row, 0);
                LayerListDialog.this.layerList.repaint();
            }

            @Override
            public void refresh() {
                LayerListDialog.this.layerList.repaint();
            }
        });
        MoveUpAction moveUpAction = new MoveUpAction(this.model);
        TableHelper.adaptTo((IEnabledStateUpdating)moveUpAction, this.model);
        TableHelper.adaptTo((IEnabledStateUpdating)moveUpAction, selectionModel);
        MoveDownAction moveDownAction = new MoveDownAction(this.model);
        TableHelper.adaptTo((IEnabledStateUpdating)moveDownAction, this.model);
        TableHelper.adaptTo((IEnabledStateUpdating)moveDownAction, selectionModel);
        this.activateLayerAction = new ActivateLayerAction(this.model);
        this.activateLayerAction.updateEnabledState();
        MultikeyActionsHandler.getInstance().addAction(this.activateLayerAction);
        TableHelper.adaptTo((IEnabledStateUpdating)this.activateLayerAction, selectionModel);
        JumpToMarkerActions.initialize();
        this.showHideLayerAction = new ShowHideLayerAction(this.model);
        MultikeyActionsHandler.getInstance().addAction(this.showHideLayerAction);
        TableHelper.adaptTo((IEnabledStateUpdating)this.showHideLayerAction, selectionModel);
        LayerVisibilityAction visibilityAction = new LayerVisibilityAction(this.model);
        TableHelper.adaptTo((IEnabledStateUpdating)visibilityAction, selectionModel);
        SideButton visibilityButton = new SideButton((Action)visibilityAction, false);
        visibilityAction.setCorrespondingSideButton(visibilityButton);
        DeleteLayerAction deleteLayerAction = new DeleteLayerAction(this.model);
        this.layerList.getActionMap().put("deleteLayer", deleteLayerAction);
        TableHelper.adaptTo((IEnabledStateUpdating)deleteLayerAction, selectionModel);
        this.getInputMap(1).put(KeyStroke.getKeyStroke(127, 0), "delete");
        this.getActionMap().put("delete", deleteLayerAction);
        InputMapUtils.addEnterAction(this.layerList, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LayerListDialog.this.activateLayerAction.actionPerformed(null);
                LayerListDialog.this.layerList.requestFocus();
            }
        });
        InputMapUtils.addSpacebarAction(this.layerList, this.showHideLayerAction);
        this.cycleLayerUpAction = new CycleLayerUpAction();
        this.cycleLayerDownAction = new CycleLayerDownAction();
        this.createLayout(this.layerList, true, Arrays.asList(new SideButton((Action)moveUpAction, false), new SideButton((Action)moveDownAction, false), new SideButton((Action)this.activateLayerAction, false), visibilityButton, new SideButton((Action)deleteLayerAction, false)));
        this.createVisibilityToggleShortcuts();
    }

    private static boolean displayLayerNumbers() {
        return ExpertToggleAction.isExpert() && DISPLAY_NUMBERS.get() != false;
    }

    public MainLayerManager getLayerManager() {
        return this.layerManager;
    }

    @Override
    public void showNotify() {
        this.layerManager.addActiveLayerChangeListener(this.activateLayerAction);
        this.layerManager.addAndFireLayerChangeListener(this.model);
        this.layerManager.addAndFireActiveLayerChangeListener(this.model);
        this.model.populate();
    }

    @Override
    public void hideNotify() {
        this.layerManager.removeAndFireLayerChangeListener(this.model);
        this.layerManager.removeActiveLayerChangeListener(this.model);
        this.layerManager.removeActiveLayerChangeListener(this.activateLayerAction);
    }

    public LayerListModel getModel() {
        return this.model;
    }

    @Override
    public void destroy() {
        for (int i = 0; i < 10; ++i) {
            MainApplication.unregisterActionShortcut(this.visibilityToggleActions[i], this.visibilityToggleShortcuts[i]);
        }
        MultikeyActionsHandler.getInstance().removeAction(this.activateLayerAction);
        MultikeyActionsHandler.getInstance().removeAction(this.showHideLayerAction);
        JumpToMarkerActions.unregisterActions();
        this.layerList.setTransferHandler(null);
        DISPLAY_NUMBERS.removeListener(this.visibilityWidthListener);
        ExpertToggleAction.removeExpertModeChangeListener(this.visibilityWidthListener);
        this.layerManager.removeLayerChangeListener(this.visibilityWidthListener);
        this.cycleLayerUpAction.destroy();
        this.cycleLayerDownAction.destroy();
        super.destroy();
        instance = null;
    }

    static ImageIcon createBlankIcon() {
        return ImageProvider.createBlankIcon(ImageProvider.ImageSizes.LAYER);
    }

    public ShowHideLayerAction createShowHideLayerAction() {
        return new ShowHideLayerAction(this.model);
    }

    public DeleteLayerAction createDeleteLayerAction() {
        return new DeleteLayerAction(this.model);
    }

    public ActivateLayerAction createActivateLayerAction(Layer layer) {
        return new ActivateLayerAction(layer, this.model);
    }

    public MergeAction createMergeLayerAction(Layer layer) {
        return new MergeAction(layer, this.model);
    }

    public DuplicateAction createDuplicateLayerAction(Layer layer) {
        return new DuplicateAction(layer, this.model);
    }

    public static Layer getLayerForIndex(int index) {
        List<Layer> layers = MainApplication.getLayerManager().getLayers();
        if (index < layers.size() && index >= 0) {
            return layers.get(index);
        }
        return null;
    }

    public static List<MultikeyShortcutAction.MultikeyInfo> getLayerInfoByClass(Class<?> layerClass) {
        ArrayList<MultikeyShortcutAction.MultikeyInfo> result = new ArrayList<MultikeyShortcutAction.MultikeyInfo>();
        List<Layer> layers = MainApplication.getLayerManager().getLayers();
        int index = 0;
        for (Layer l : layers) {
            if (layerClass.isAssignableFrom(l.getClass())) {
                result.add(new MultikeyShortcutAction.MultikeyInfo(index, l.getName()));
            }
            ++index;
        }
        return result;
    }

    public static boolean isLayerValid(Layer l) {
        if (l == null) {
            return false;
        }
        return MainApplication.getLayerManager().containsLayer(l);
    }

    public static MultikeyShortcutAction.MultikeyInfo getLayerInfo(Layer l) {
        if (l == null) {
            return null;
        }
        int index = MainApplication.getLayerManager().getLayers().indexOf(l);
        if (index < 0) {
            return null;
        }
        return new MultikeyShortcutAction.MultikeyInfo(index, l.getName());
    }

    @Override
    public void displaySettingsChanged(TileSourceDisplaySettings.DisplaySettingsChangeEvent e) {
        if ("displacement".equals(e.getChangedSetting())) {
            this.layerList.repaint();
        }
    }

    static {
        DISPLAY_NUMBERS = new BooleanProperty("layerlist.display.numbers", true);
    }

    static class LayerList
    extends ScrollableTable {
        LayerList(LayerListModel dataModel) {
            super(dataModel);
            dataModel.setLayerList(this);
            if (!GraphicsEnvironment.isHeadless()) {
                this.setDragEnabled(true);
            }
            this.setDropMode(DropMode.INSERT_ROWS);
            this.setTransferHandler(new LayerListTransferHandler());
        }

        @Override
        public LayerListModel getModel() {
            return (LayerListModel)super.getModel();
        }
    }

    public static final class LayerListModel
    extends AbstractTableModel
    implements LayerManager.LayerChangeListener,
    MainLayerManager.ActiveLayerChangeListener,
    PropertyChangeListener,
    ReorderableTableModel<Layer> {
        private final DefaultListSelectionModel selectionModel;
        private final CopyOnWriteArrayList<LayerListModelListener> listeners;
        private LayerList layerList;
        private final MainLayerManager layerManager;

        LayerListModel(MainLayerManager layerManager, DefaultListSelectionModel selectionModel) {
            this.layerManager = layerManager;
            this.selectionModel = selectionModel;
            this.listeners = new CopyOnWriteArrayList();
        }

        void setLayerList(LayerList layerList) {
            this.layerList = layerList;
        }

        public MainLayerManager getLayerManager() {
            return this.layerManager;
        }

        public void addLayerListModelListener(LayerListModelListener listener) {
            if (listener != null) {
                this.listeners.addIfAbsent(listener);
            }
        }

        public void removeLayerListModelListener(LayerListModelListener listener) {
            this.listeners.remove(listener);
        }

        private void fireMakeVisible(int index, Layer layer) {
            for (LayerListModelListener listener : this.listeners) {
                listener.makeVisible(index, layer);
            }
        }

        private void fireRefresh() {
            for (LayerListModelListener listener : this.listeners) {
                listener.refresh();
            }
        }

        public void populate() {
            for (Layer layer : this.getLayers()) {
                layer.removePropertyChangeListener(this);
                layer.addPropertyChangeListener(this);
            }
            this.fireTableDataChanged();
        }

        public void setSelectedLayer(Layer layer) {
            if (layer == null) {
                return;
            }
            int idx = this.getLayers().indexOf(layer);
            if (idx >= 0) {
                this.selectionModel.setSelectionInterval(idx, idx);
            }
            this.ensureSelectedIsVisible();
        }

        public List<Layer> getSelectedLayers() {
            List<Layer> layers = this.getLayers();
            return IntStream.range(0, layers.size()).filter(this.selectionModel::isSelectedIndex).mapToObj(layers::get).collect(Collectors.toList());
        }

        public List<Integer> getSelectedRows() {
            return ArrayUtils.toList(TableHelper.getSelectedIndices(this.selectionModel));
        }

        private void onRemoveLayer(Layer layer) {
            if (layer == null) {
                return;
            }
            layer.removePropertyChangeListener(this);
            int size = this.getRowCount();
            int[] rows = TableHelper.getSelectedIndices(this.selectionModel);
            if (rows.length == 0 && size > 0) {
                this.selectionModel.setSelectionInterval(size - 1, size - 1);
            }
            this.fireTableDataChanged();
            this.fireRefresh();
            this.ensureActiveSelected();
        }

        private void onAddLayer(Layer layer) {
            if (layer == null) {
                return;
            }
            layer.addPropertyChangeListener(this);
            this.fireTableDataChanged();
            int idx = this.getLayers().indexOf(layer);
            Icon icon = layer.getIcon();
            if (this.layerList != null && icon != null) {
                this.layerList.setRowHeight(idx, Math.max(this.layerList.getRowHeight(), icon.getIconHeight()));
            }
            this.selectionModel.setSelectionInterval(idx, idx);
            this.ensureSelectedIsVisible();
            if (layer instanceof AbstractTileSourceLayer) {
                ((AbstractTileSourceLayer)layer).getDisplaySettings().addSettingsChangeListener(LayerListDialog.getInstance());
            }
        }

        public Layer getFirstLayer() {
            if (this.getRowCount() == 0) {
                return null;
            }
            return this.getLayers().get(0);
        }

        public Layer getLayer(int index) {
            if (index < 0 || index >= this.getRowCount()) {
                return null;
            }
            return this.getLayers().get(index);
        }

        @Override
        public DefaultListSelectionModel getSelectionModel() {
            return this.selectionModel;
        }

        @Override
        public Layer getValue(int index) {
            return this.getLayer(index);
        }

        @Override
        public Layer setValue(int index, Layer value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean doMove(int delta, int ... selectedRows) {
            if (delta != 0) {
                List<Layer> layers = this.getLayers();
                MapView mapView = MainApplication.getMap().mapView;
                if (delta < 0) {
                    for (int row : selectedRows) {
                        mapView.moveLayer(layers.get(row), row + delta);
                    }
                } else {
                    for (int i = selectedRows.length - 1; i >= 0; --i) {
                        mapView.moveLayer(layers.get(selectedRows[i]), selectedRows[i] + delta);
                    }
                }
                this.fireTableDataChanged();
            }
            return delta != 0;
        }

        @Override
        public boolean move(int delta, int ... selectedRows) {
            if (!ReorderableTableModel.super.move(delta, selectedRows)) {
                return false;
            }
            this.ensureSelectedIsVisible();
            return true;
        }

        private void ensureSelectedIsVisible() {
            int index = this.selectionModel.getMinSelectionIndex();
            if (index < 0) {
                return;
            }
            List<Layer> layers = this.getLayers();
            if (index >= layers.size()) {
                return;
            }
            Layer layer = layers.get(index);
            this.fireMakeVisible(index, layer);
        }

        public List<Layer> getPossibleMergeTargets(Layer source) {
            if (source == null) {
                return new ArrayList<Layer>();
            }
            return this.getLayers().stream().filter(target -> source != target && target.isMergable(source) && source.isMergable((Layer)target)).collect(Collectors.toList());
        }

        public List<Layer> getLayers() {
            return this.getLayerManager().getLayers();
        }

        private void ensureActiveSelected() {
            List<Layer> layers = this.getLayers();
            if (layers.isEmpty()) {
                return;
            }
            Layer activeLayer = this.getActiveLayer();
            if (activeLayer != null) {
                int idx = layers.indexOf(activeLayer);
                this.selectionModel.setSelectionInterval(idx, idx);
                this.ensureSelectedIsVisible();
            } else {
                this.selectionModel.setSelectionInterval(0, 0);
                this.ensureSelectedIsVisible();
            }
        }

        private Layer getActiveLayer() {
            return this.getLayerManager().getActiveLayer();
        }

        @Override
        public int getRowCount() {
            List<Layer> layers = this.getLayers();
            return layers == null ? 0 : layers.size();
        }

        @Override
        public int getColumnCount() {
            return 5;
        }

        @Override
        public Object getValueAt(int row, int col) {
            List<Layer> layers = this.getLayers();
            if (row >= 0 && row < layers.size()) {
                switch (col) {
                    case 0: {
                        return layers.get(row) == this.getActiveLayer();
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        return layers.get(row);
                    }
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col != 0 || this.getActiveLayer() != this.getLayers().get(row);
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            List<Layer> layers = this.getLayers();
            if (row < layers.size()) {
                Layer l = layers.get(row);
                switch (col) {
                    case 0: {
                        this.getLayerManager().setActiveLayer(l);
                        l.setVisible(true);
                        break;
                    }
                    case 1: {
                        int idx;
                        MapFrame map = MainApplication.getMap();
                        NativeScaleLayer oldLayer = map.mapView.getNativeScaleLayer();
                        if (oldLayer == l) {
                            map.mapView.setNativeScaleLayer(null);
                            break;
                        }
                        if (!(l instanceof NativeScaleLayer)) break;
                        map.mapView.setNativeScaleLayer((NativeScaleLayer)((Object)l));
                        if (!(oldLayer instanceof Layer) || (idx = this.getLayers().indexOf((Layer)((Object)oldLayer))) < 0) break;
                        this.fireTableCellUpdated(idx, col);
                        break;
                    }
                    case 2: {
                        if (!(l instanceof AbstractTileSourceLayer)) break;
                        TileSourceDisplaySettings displaySettings = ((AbstractTileSourceLayer)l).getDisplaySettings();
                        OffsetBookmark offsetBookmark = displaySettings.getOffsetBookmark();
                        if (offsetBookmark != null) {
                            displaySettings.setOffsetBookmark(null);
                            MainApplication.getMenu().imageryMenu.refreshOffsetMenu();
                            break;
                        }
                        displaySettings.setOffsetBookmark(displaySettings.getPreviousOffsetBookmark());
                        break;
                    }
                    case 3: {
                        l.setVisible((Boolean)value);
                        break;
                    }
                    case 4: {
                        l.rename((String)value);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Wrong column: " + col);
                    }
                }
                this.fireTableCellUpdated(row, col);
            }
        }

        @Override
        public void activeOrEditLayerChanged(MainLayerManager.ActiveLayerChangeEvent e) {
            int idx;
            Layer newLayer;
            int idx2;
            Layer oldLayer = e.getPreviousActiveLayer();
            if (oldLayer != null && (idx2 = this.getLayers().indexOf(oldLayer)) >= 0) {
                this.fireTableRowsUpdated(idx2, idx2);
            }
            if ((newLayer = this.getActiveLayer()) != null && (idx = this.getLayers().indexOf(newLayer)) >= 0) {
                this.fireTableRowsUpdated(idx, idx);
            }
            this.ensureActiveSelected();
        }

        @Override
        public void layerAdded(LayerManager.LayerAddEvent e) {
            this.onAddLayer(e.getAddedLayer());
        }

        @Override
        public void layerRemoving(LayerManager.LayerRemoveEvent e) {
            this.onRemoveLayer(e.getRemovedLayer());
        }

        @Override
        public void layerOrderChanged(LayerManager.LayerOrderChangeEvent e) {
            this.fireTableDataChanged();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() instanceof Layer) {
                Layer layer = (Layer)evt.getSource();
                int idx = this.getLayers().indexOf(layer);
                if (idx < 0) {
                    return;
                }
                this.fireRefresh();
            }
        }
    }

    public static interface LayerListModelListener {
        public void makeVisible(int var1, Layer var2);

        public void refresh();
    }

    class PopupMenuHandler
    extends PopupMenuLauncher {
        PopupMenuHandler() {
        }

        @Override
        public void showMenu(MouseEvent evt) {
            this.menu = new LayerListPopup(LayerListDialog.this.getModel().getSelectedLayers());
            super.showMenu(evt);
        }
    }

    private static class LayerNameCellEditor
    extends DefaultCellEditor {
        LayerNameCellEditor(DisableShortcutsOnFocusGainedTextField tf) {
            super(tf);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            JosmTextField tf = (JosmTextField)super.getTableCellEditorComponent(table, value, isSelected, row, column);
            tf.setText(value == null ? "" : ((Layer)value).getName());
            return tf;
        }
    }

    private class LayerNameCellRenderer
    extends DefaultTableCellRenderer {
        private LayerNameCellRenderer() {
        }

        protected boolean isActiveLayer(Layer layer) {
            return LayerListDialog.this.getLayerManager().getActiveLayer() == layer;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                return this;
            }
            Layer layer = (Layer)value;
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, layer.getName(), isSelected, hasFocus, row, column);
            if (this.isActiveLayer(layer)) {
                label.setFont(label.getFont().deriveFont(1));
            }
            label.setIcon(layer.getIcon());
            label.setToolTipText(layer.getToolTipText());
            return label;
        }
    }

    private static class OffsetLayerCellRenderer
    implements TableCellRenderer {
        private final JCheckBox cb = new OffsetLayerCheckBox();

        OffsetLayerCellRenderer() {
            this.cb.setEnabled(false);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Layer layer = (Layer)value;
            if (layer instanceof AbstractTileSourceLayer) {
                TileSourceDisplaySettings displaySettings = ((AbstractTileSourceLayer)layer).getDisplaySettings();
                if (EastNorth.ZERO.equals(displaySettings.getDisplacement())) {
                    boolean hasPreviousOffset = displaySettings.getPreviousOffsetBookmark() != null;
                    this.cb.setSelected(false);
                    this.cb.setEnabled(hasPreviousOffset);
                    this.cb.setToolTipText(I18n.tr("layer is without a user-defined offset", new Object[0]) + (hasPreviousOffset ? " " + I18n.tr("(click to activate previous offset)", new Object[0]) : ""));
                } else {
                    this.cb.setSelected(true);
                    this.cb.setEnabled(true);
                    this.cb.setToolTipText(I18n.tr("layer has an offset of {0} (click to remove offset)", displaySettings.getDisplacementString(Locale.getDefault())));
                }
            } else {
                this.cb.setSelected(false);
                this.cb.setEnabled(false);
                this.cb.setToolTipText(I18n.tr("this layer can not have an offset", new Object[0]));
            }
            return this.cb;
        }
    }

    private static class NativeScaleLayerCellRenderer
    implements TableCellRenderer {
        private final JCheckBox cb = new NativeScaleLayerCheckBox();

        NativeScaleLayerCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Layer layer = (Layer)value;
            if (layer instanceof NativeScaleLayer) {
                boolean active = (NativeScaleLayer)((Object)layer) == MainApplication.getMap().mapView.getNativeScaleLayer();
                this.cb.setSelected(active);
                if (MainApplication.getMap().mapView.getNativeScaleLayer() != null) {
                    this.cb.setToolTipText(active ? I18n.tr("scale follows native resolution of this layer", new Object[0]) : I18n.tr("scale follows native resolution of another layer (click to set this layer)", new Object[0]));
                } else {
                    this.cb.setToolTipText(I18n.tr("scale does not follow native resolution of any layer (click to set this layer)", new Object[0]));
                }
            } else {
                this.cb.setSelected(false);
                this.cb.setToolTipText(I18n.tr("this layer has no native resolution", new Object[0]));
            }
            return this.cb;
        }
    }

    private static class LayerVisibleCellEditor
    extends DefaultCellEditor {
        private final LayerVisibleCheckBox cb;

        LayerVisibleCellEditor(LayerVisibleCheckBox cb) {
            super(cb);
            this.cb = cb;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.cb.updateStatus((Layer)value);
            return this.cb;
        }
    }

    private static class LayerVisibleCellRenderer
    implements TableCellRenderer {
        private final LayerVisibleCheckBox cb = new LayerVisibleCheckBox();

        LayerVisibleCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value != null) {
                this.cb.updateStatus((Layer)value);
            }
            return this.cb;
        }
    }

    private static class ActiveLayerCellRenderer
    implements TableCellRenderer {
        private final JCheckBox cb = new ActiveLayerCheckBox();

        ActiveLayerCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            boolean active = value != null && (Boolean)value != false;
            this.cb.setSelected(active);
            this.cb.setToolTipText(active ? I18n.tr("this layer is the active layer", new Object[0]) : I18n.tr("this layer is not currently active (click to activate)", new Object[0]));
            return this.cb;
        }
    }

    private static class OffsetLayerCheckBox
    extends JCheckBox {
        OffsetLayerCheckBox() {
            this.setHorizontalAlignment(0);
            ImageIcon blank = LayerListDialog.createBlankIcon();
            ImageIcon withOffset = ImageProvider.get("dialogs/layerlist", "offset");
            this.setIcon(blank);
            this.setSelectedIcon(withOffset);
        }
    }

    private static class NativeScaleLayerCheckBox
    extends JCheckBox {
        NativeScaleLayerCheckBox() {
            this.setHorizontalAlignment(0);
            ImageIcon blank = LayerListDialog.createBlankIcon();
            ImageIcon active = ImageProvider.get("dialogs/layerlist", "scale");
            this.setIcon(blank);
            this.setSelectedIcon(active);
        }
    }

    private static class LayerVisibleCheckBox
    extends JCheckBox {
        private final ImageIcon iconEye = new EyeIcon("eye");
        private final ImageIcon iconEyeTranslucent = new EyeIcon("eye-translucent", true);
        private boolean isTranslucent;
        private Layer layer;

        LayerVisibleCheckBox() {
            this.setIcon(ImageProvider.get("dialogs/layerlist", "eye-off"));
            this.setSelectedIcon(this.iconEye);
            this.isTranslucent = false;
        }

        public void setTranslucent(boolean isTranslucent) {
            if (this.isTranslucent == isTranslucent) {
                return;
            }
            if (isTranslucent) {
                this.setSelectedIcon(this.iconEyeTranslucent);
            } else {
                this.setSelectedIcon(this.iconEye);
            }
            this.isTranslucent = isTranslucent;
        }

        public void updateStatus(Layer layer) {
            this.layer = layer;
            boolean visible = layer.isVisible();
            this.setSelected(visible);
            if (LayerListDialog.displayLayerNumbers()) {
                List<Layer> layers = MainApplication.getLayerManager().getLayers();
                int num = layers.size() - layers.indexOf(layer);
                this.setText(String.format("%s[%d]", num < 10 ? " " : "", num));
            } else {
                this.setText(null);
            }
            this.setTranslucent(layer.getOpacity() < 1.0);
            this.setToolTipText(visible ? I18n.tr("layer is currently visible (click to hide layer)", new Object[0]) : I18n.tr("layer is currently hidden (click to show layer)", new Object[0]));
        }

        private class EyeIcon
        extends ImageIcon {
            private final boolean translucent;

            EyeIcon(String name) {
                this(name, false);
            }

            EyeIcon(String name, boolean translucent) {
                super(ImageProvider.get("dialogs/layerlist", name).getImage());
                this.translucent = translucent;
            }

            @Override
            public synchronized void paintIcon(Component comp, Graphics g, int x, int y) {
                Color c;
                if (Config.getPref().getBoolean("dialog.layer.colorname", true) && LayerVisibleCheckBox.this.layer != null && (c = LayerVisibleCheckBox.this.layer.getColor()) != null) {
                    if (g instanceof Graphics2D) {
                        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    }
                    if (this.translucent) {
                        g.setColor(new Color(c.getRed(), c.getGreen(), c.getBlue(), 125));
                    } else {
                        g.setColor(c);
                    }
                    g.fillOval(x, y + 2, this.getIconWidth(), this.getIconHeight() - 3);
                }
                super.paintIcon(comp, g, x, y);
            }
        }
    }

    private static class ActiveLayerCheckBox
    extends JCheckBox {
        ActiveLayerCheckBox() {
            this.setHorizontalAlignment(0);
            ImageIcon blank = LayerListDialog.createBlankIcon();
            ImageIcon active = ImageProvider.get("dialogs/layerlist", "active");
            this.setIcon(blank);
            this.setSelectedIcon(active);
            this.setRolloverIcon(blank);
            this.setRolloverSelectedIcon(active);
        }
    }

    private class ColumnWidthAdaptionListener
    implements AbstractProperty.ValueChangeListener<Boolean>,
    ExpertToggleAction.ExpertModeChangeListener,
    LayerManager.LayerChangeListener {
        private final int minWidth;
        private final int column;

        ColumnWidthAdaptionListener(int column, int minWidth) {
            this.column = column;
            this.minWidth = minWidth;
        }

        @Override
        public void expertChanged(boolean isExpert) {
            this.updateColumnWidth();
        }

        @Override
        public void valueChanged(AbstractProperty.ValueChangeEvent<? extends Boolean> e) {
            this.updateColumnWidth();
        }

        @Override
        public void layerAdded(LayerManager.LayerAddEvent e) {
            this.updateColumnWidth();
        }

        @Override
        public void layerRemoving(LayerManager.LayerRemoveEvent e) {
            this.updateColumnWidth();
        }

        @Override
        public void layerOrderChanged(LayerManager.LayerOrderChangeEvent e) {
        }

        public void updateColumnWidth() {
            int width = this.minWidth;
            for (int row = 0; row < LayerListDialog.this.layerList.getRowCount(); ++row) {
                TableCellRenderer renderer = LayerListDialog.this.layerList.getCellRenderer(row, this.column);
                Component comp = LayerListDialog.this.layerList.prepareRenderer(renderer, row, this.column);
                width = Math.max(comp.getPreferredSize().width + 1, width);
            }
            LayerListDialog.this.layerList.getColumnModel().getColumn(this.column).setMaxWidth(width);
            LayerListDialog.this.layerList.getColumnModel().getColumn(this.column).setPreferredWidth(width);
            LayerListDialog.this.repaint();
        }
    }

    private final class ToggleLayerIndexVisibility
    extends AbstractAction {
        private final int layerIndex;

        ToggleLayerIndexVisibility(int layerIndex) {
            this.layerIndex = layerIndex;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Layer l = LayerListDialog.this.model.getLayer(LayerListDialog.this.model.getRowCount() - this.layerIndex - 1);
            if (l != null) {
                l.toggleVisible();
            }
        }
    }
}

