/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.widgets;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import org.openstreetmap.josm.data.preferences.ListProperty;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MainFrame;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.PlatformManager;

public class OrientationAction
extends AbstractAction
implements PropertyChangeListener {
    private static final List<String> DEFAULT_RTL_LANGUAGES = Arrays.asList("ar", "he", "fa", "ps", "iw", "ur");
    private static final List<String> DEFAULT_LOCALIZED_KEYS = Arrays.asList("(\\p{Alnum}+_)?name", "addr", "description", "fixme", "note", "source", "strapline", "operator");
    public static final ListProperty RTL_LANGUAGES = new ListProperty("properties.rtl-languages", DEFAULT_RTL_LANGUAGES);
    public static final ListProperty LOCALIZED_KEYS = new ListProperty("properties.localized-keys", DEFAULT_LOCALIZED_KEYS);
    private static final Pattern LANG_PATTERN = Pattern.compile(":([a-z]{2,3})$");
    private static final String NEW_STATE = "newState";
    private Component component;
    private ImageIcon iconRTL;
    private ImageIcon iconLTR;
    protected static final Set<String> RTLLanguages = new HashSet<String>((Collection<String>)RTL_LANGUAGES.get());
    protected static final Pattern localizedKeys = OrientationAction.compileLocalizedKeys();

    public OrientationAction(Component component) {
        super(null);
        this.component = component;
        this.setEnabled(true);
        if (Config.getPref().getBoolean("text.popupmenu.useicons", true)) {
            this.iconLTR = new ImageProvider("dialogs/next").setSize(ImageProvider.ImageSizes.SMALLICON).get();
            this.iconRTL = new ImageProvider("dialogs/previous").setSize(ImageProvider.ImageSizes.SMALLICON).get();
        }
        component.addPropertyChangeListener(this);
        this.putValue("AcceleratorKey", OrientationAction.getShortcutKey());
        this.updateState();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.firePropertyChange("orientationAction", null, this.getValue(NEW_STATE));
    }

    public void updateState() {
        if (this.component.getComponentOrientation().isLeftToRight()) {
            this.putValue("Name", I18n.tr("Right to Left", new Object[0]));
            this.putValue("SmallIcon", this.iconRTL);
            this.putValue("ShortDescription", I18n.tr("Switch the text orientation to Right-to-Left.", new Object[0]));
            this.putValue(NEW_STATE, ComponentOrientation.RIGHT_TO_LEFT);
        } else {
            this.putValue("Name", I18n.tr("Left to Right", new Object[0]));
            this.putValue("SmallIcon", this.iconLTR);
            this.putValue("ShortDescription", I18n.tr("Switch the text orientation to Left-to-Right.", new Object[0]));
            this.putValue(NEW_STATE, ComponentOrientation.LEFT_TO_RIGHT);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("componentOrientation".equals(evt.getPropertyName())) {
            this.updateState();
        }
    }

    public static KeyStroke getShortcutKey() {
        return KeyStroke.getKeyStroke(32, PlatformManager.getPlatform().getMenuShortcutKeyMaskEx());
    }

    public static ComponentOrientation getDefaultComponentOrientation() {
        MainFrame main = MainApplication.getMainFrame();
        return main != null ? main.getComponentOrientation() : ComponentOrientation.LEFT_TO_RIGHT;
    }

    public static ComponentOrientation getValueOrientation(String key) {
        if (key == null || key.isEmpty()) {
            return ComponentOrientation.LEFT_TO_RIGHT;
        }
        Matcher m = LANG_PATTERN.matcher(key);
        if (m.find()) {
            if (RTLLanguages.contains(m.group(1))) {
                return ComponentOrientation.RIGHT_TO_LEFT;
            }
            return ComponentOrientation.LEFT_TO_RIGHT;
        }
        return ComponentOrientation.getOrientation(Locale.getDefault());
    }

    public static ComponentOrientation getNamelikeOrientation(String key) {
        if (key == null || key.isEmpty()) {
            return ComponentOrientation.LEFT_TO_RIGHT;
        }
        Matcher m = LANG_PATTERN.matcher(key);
        if (m.find()) {
            if (RTLLanguages.contains(m.group(1))) {
                return ComponentOrientation.RIGHT_TO_LEFT;
            }
            return ComponentOrientation.LEFT_TO_RIGHT;
        }
        m = localizedKeys.matcher(key);
        if (m.find()) {
            return ComponentOrientation.getOrientation(Locale.getDefault());
        }
        return ComponentOrientation.LEFT_TO_RIGHT;
    }

    private static Pattern compileLocalizedKeys() {
        return Pattern.compile("^(" + String.join((CharSequence)"|", (Iterable<? extends CharSequence>)LOCALIZED_KEYS.get()) + ")$");
    }
}

