/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.parsson;

import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonPatch;
import jakarta.json.JsonPatchBuilder;
import jakarta.json.JsonStructure;
import jakarta.json.JsonValue;
import org.eclipse.parsson.JsonArrayBuilderImpl;
import org.eclipse.parsson.JsonContext;
import org.eclipse.parsson.JsonObjectBuilderImpl;
import org.eclipse.parsson.JsonPatchImpl;

public final class JsonPatchBuilderImpl
implements JsonPatchBuilder {
    private final JsonContext jsonContext;
    private final JsonArrayBuilder builder;

    public JsonPatchBuilderImpl(JsonArray patch, JsonContext jsonContext) {
        this.jsonContext = jsonContext;
        this.builder = new JsonArrayBuilderImpl(patch, jsonContext);
    }

    public JsonPatchBuilderImpl(JsonContext jsonContext) {
        this.jsonContext = jsonContext;
        this.builder = new JsonArrayBuilderImpl(jsonContext);
    }

    public <T extends JsonStructure> T apply(T target) {
        return this.build().apply(target);
    }

    @Override
    public JsonPatchBuilder add(String path, JsonValue value) {
        this.builder.add(new JsonObjectBuilderImpl(this.jsonContext).add("op", JsonPatch.Operation.ADD.operationName()).add("path", path).add("value", value));
        return this;
    }

    @Override
    public JsonPatchBuilder add(String path, String value) {
        this.builder.add(new JsonObjectBuilderImpl(this.jsonContext).add("op", JsonPatch.Operation.ADD.operationName()).add("path", path).add("value", value));
        return this;
    }

    @Override
    public JsonPatchBuilder add(String path, int value) {
        this.builder.add(new JsonObjectBuilderImpl(this.jsonContext).add("op", JsonPatch.Operation.ADD.operationName()).add("path", path).add("value", value));
        return this;
    }

    @Override
    public JsonPatchBuilder add(String path, boolean value) {
        this.builder.add(new JsonObjectBuilderImpl(this.jsonContext).add("op", JsonPatch.Operation.ADD.operationName()).add("path", path).add("value", value));
        return this;
    }

    @Override
    public JsonPatchBuilder remove(String path) {
        this.builder.add(new JsonObjectBuilderImpl(this.jsonContext).add("op", JsonPatch.Operation.REMOVE.operationName()).add("path", path));
        return this;
    }

    @Override
    public JsonPatchBuilder replace(String path, JsonValue value) {
        this.builder.add(new JsonObjectBuilderImpl(this.jsonContext).add("op", JsonPatch.Operation.REPLACE.operationName()).add("path", path).add("value", value));
        return this;
    }

    @Override
    public JsonPatchBuilder replace(String path, String value) {
        this.builder.add(new JsonObjectBuilderImpl(this.jsonContext).add("op", JsonPatch.Operation.REPLACE.operationName()).add("path", path).add("value", value));
        return this;
    }

    @Override
    public JsonPatchBuilder replace(String path, int value) {
        this.builder.add(new JsonObjectBuilderImpl(this.jsonContext).add("op", JsonPatch.Operation.REPLACE.operationName()).add("path", path).add("value", value));
        return this;
    }

    @Override
    public JsonPatchBuilder replace(String path, boolean value) {
        this.builder.add(new JsonObjectBuilderImpl(this.jsonContext).add("op", JsonPatch.Operation.REPLACE.operationName()).add("path", path).add("value", value));
        return this;
    }

    @Override
    public JsonPatchBuilder move(String path, String from) {
        this.builder.add(new JsonObjectBuilderImpl(this.jsonContext).add("op", JsonPatch.Operation.MOVE.operationName()).add("path", path).add("from", from));
        return this;
    }

    @Override
    public JsonPatchBuilder copy(String path, String from) {
        this.builder.add(new JsonObjectBuilderImpl(this.jsonContext).add("op", JsonPatch.Operation.COPY.operationName()).add("path", path).add("from", from));
        return this;
    }

    @Override
    public JsonPatchBuilder test(String path, JsonValue value) {
        this.builder.add(new JsonObjectBuilderImpl(this.jsonContext).add("op", JsonPatch.Operation.TEST.operationName()).add("path", path).add("value", value));
        return this;
    }

    @Override
    public JsonPatchBuilder test(String path, String value) {
        this.builder.add(new JsonObjectBuilderImpl(this.jsonContext).add("op", JsonPatch.Operation.TEST.operationName()).add("path", path).add("value", value));
        return this;
    }

    @Override
    public JsonPatchBuilder test(String path, int value) {
        this.builder.add(new JsonObjectBuilderImpl(this.jsonContext).add("op", JsonPatch.Operation.TEST.operationName()).add("path", path).add("value", value));
        return this;
    }

    @Override
    public JsonPatchBuilder test(String path, boolean value) {
        this.builder.add(new JsonObjectBuilderImpl(this.jsonContext).add("op", JsonPatch.Operation.TEST.operationName()).add("path", path).add("value", value));
        return this;
    }

    public JsonArray buildAsJsonArray() {
        return this.builder.build();
    }

    @Override
    public JsonPatch build() {
        return new JsonPatchImpl(this.buildAsJsonArray(), this.jsonContext);
    }
}

