/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection.proj;

import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.projection.ProjectionConfigurationException;
import org.openstreetmap.josm.data.projection.proj.AbstractProj;
import org.openstreetmap.josm.data.projection.proj.ProjParameters;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class LambertAzimuthalEqualArea
extends AbstractProj {
    private static final double EPSILON = 1.0E-7;
    private static final double FINE_EPSILON = 1.0E-10;
    private static final double EPSILON_LATITUDE = 1.0E-10;
    private static final double P00 = 0.333333333333333;
    private static final double P01 = 0.172222222222222;
    private static final double P02 = 0.102579365079365;
    private static final double P10 = 0.0638888888888889;
    private static final double P11 = 0.0664021164021164;
    private static final double P20 = 0.0164150129421915;
    private Mode mode;
    private double sinb1;
    private double cosb1;
    private double xmf;
    private double ymf;
    private double qp;
    private double dd;
    private double rq;
    private double aPA0;
    private double aPA1;
    private double aPA2;
    private double latitudeOfOrigin;

    @Override
    public String getName() {
        return I18n.tr("Lambert Azimuthal Equal Area", new Object[0]);
    }

    @Override
    public String getProj4Id() {
        return "laea";
    }

    @Override
    public void initialize(ProjParameters params) throws ProjectionConfigurationException {
        super.initialize(params);
        if (params.lat0 == null) {
            throw new ProjectionConfigurationException(I18n.tr("Parameter ''{0}'' required.", "lat_0"));
        }
        this.latitudeOfOrigin = Utils.toRadians(params.lat0);
        double t = Math.abs(this.latitudeOfOrigin);
        this.mode = Math.abs(t - 1.5707963267948966) < 1.0E-10 ? (this.latitudeOfOrigin < 0.0 ? Mode.SOUTH_POLE : Mode.NORTH_POLE) : (Math.abs(t) < 1.0E-10 ? Mode.EQUATORIAL : Mode.OBLIQUE);
        double es2 = this.e2 * this.e2;
        double es3 = this.e2 * es2;
        this.aPA0 = 0.102579365079365 * es3 + 0.172222222222222 * es2 + 0.333333333333333 * this.e2;
        this.aPA1 = 0.0664021164021164 * es3 + 0.0638888888888889 * es2;
        this.aPA2 = 0.0164150129421915 * es3;
        this.qp = this.qsfn(1.0);
        this.rq = Math.sqrt(0.5 * this.qp);
        double sinphi = Math.sin(this.latitudeOfOrigin);
        this.sinb1 = this.qsfn(sinphi) / this.qp;
        this.cosb1 = Math.sqrt(1.0 - this.sinb1 * this.sinb1);
        switch (this.mode.ordinal()) {
            case 2: 
            case 3: {
                this.dd = 1.0;
                this.xmf = this.ymf = this.rq;
                break;
            }
            case 1: {
                this.dd = 1.0 / this.rq;
                this.xmf = 1.0;
                this.ymf = 0.5 * this.qp;
                break;
            }
            case 0: {
                this.dd = Math.cos(this.latitudeOfOrigin) / (Math.sqrt(1.0 - this.e2 * sinphi * sinphi) * this.rq * this.cosb1);
                this.xmf = this.rq * this.dd;
                this.ymf = this.rq / this.dd;
            }
        }
    }

    @Override
    public double[] project(double phi, double lambda) {
        double coslam = Math.cos(lambda);
        double sinlam = Math.sin(lambda);
        double sinphi = Math.sin(phi);
        double q = this.qsfn(sinphi);
        double c = 0.0;
        double x = 0.0;
        double y = 0.0;
        switch (this.mode.ordinal()) {
            case 0: {
                double sinb = q / this.qp;
                double cosb = Math.sqrt(1.0 - sinb * sinb);
                c = 1.0 + this.sinb1 * sinb + this.cosb1 * cosb * coslam;
                double b = Math.sqrt(2.0 / c);
                y = this.ymf * b * (this.cosb1 * sinb - this.sinb1 * cosb * coslam);
                x = this.xmf * b * cosb * sinlam;
                break;
            }
            case 1: {
                double sinb = q / this.qp;
                double cosb = Math.sqrt(1.0 - sinb * sinb);
                c = 1.0 + cosb * coslam;
                double b = Math.sqrt(2.0 / c);
                y = this.ymf * b * sinb;
                x = this.xmf * b * cosb * sinlam;
                break;
            }
            case 2: {
                c = 1.5707963267948966 + phi;
                q = this.qp - q;
                if (q >= 0.0) {
                    double b = Math.sqrt(q);
                    x = b * sinlam;
                    y = coslam * -b;
                    break;
                }
                y = 0.0;
                x = 0.0;
                break;
            }
            case 3: {
                c = phi - 1.5707963267948966;
                q = this.qp + q;
                if (q >= 0.0) {
                    double b = Math.sqrt(q);
                    x = b * sinlam;
                    y = coslam * b;
                    break;
                }
                y = 0.0;
                x = 0.0;
            }
        }
        if (Math.abs(c) < 1.0E-10) {
            return new double[]{0.0, 0.0};
        }
        return new double[]{x, y};
    }

    @Override
    public double[] invproject(double x, double y) {
        switch (this.mode.ordinal()) {
            case 0: 
            case 1: {
                return this.invprojectEO(x, y);
            }
            case 2: {
                return this.invprojectNS(x, -y);
            }
            case 3: {
                return this.invprojectNS(x, y);
            }
        }
        throw new AssertionError((Object)this.mode);
    }

    private double[] invprojectEO(double x, double y) {
        double phi;
        double lambda;
        double rho = Math.hypot(x /= this.dd, y *= this.dd);
        if (rho < 1.0E-10) {
            lambda = 0.0;
            phi = this.latitudeOfOrigin;
        } else {
            double ab;
            double sCe = 2.0 * Math.asin(0.5 * rho / this.rq);
            double cCe = Math.cos(sCe);
            sCe = Math.sin(sCe);
            x *= sCe;
            if (this.mode == Mode.OBLIQUE) {
                ab = cCe * this.sinb1 + y * sCe * this.cosb1 / rho;
                y = rho * this.cosb1 * cCe - y * this.sinb1 * sCe;
            } else {
                ab = y * sCe / rho;
                y = rho * cCe;
            }
            lambda = Math.atan2(x, y);
            phi = this.authlat(Math.asin(ab));
        }
        return new double[]{phi, lambda};
    }

    private double[] invprojectNS(double x, double y) {
        double phi;
        double lambda;
        double q = x * x + y * y;
        if (q == 0.0) {
            lambda = 0.0;
            phi = this.latitudeOfOrigin;
        } else {
            double ab = 1.0 - q / this.qp;
            if (this.mode == Mode.SOUTH_POLE) {
                ab = -ab;
            }
            lambda = Math.atan2(x, y);
            phi = this.authlat(Math.asin(ab));
        }
        return new double[]{phi, lambda};
    }

    private double qsfn(double sinphi) {
        if (this.e >= 1.0E-7) {
            double con = this.e * sinphi;
            return (1.0 - this.e2) * (sinphi / (1.0 - con * con) - 0.5 / this.e * Math.log((1.0 - con) / (1.0 + con)));
        }
        return sinphi + sinphi;
    }

    private double authlat(double beta) {
        double t = beta + beta;
        return beta + this.aPA0 * Math.sin(t) + this.aPA1 * Math.sin(t + t) + this.aPA2 * Math.sin(t + t + t);
    }

    @Override
    public Bounds getAlgorithmBounds() {
        return new Bounds(-89.0, -174.0, 89.0, 174.0, false);
    }

    private static enum Mode {
        OBLIQUE,
        EQUATORIAL,
        NORTH_POLE,
        SOUTH_POLE;

    }
}

