/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io.importexport;

import java.io.File;
import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.io.importexport.Options;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.ImportCancelException;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Stopwatch;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.bugreport.BugReportExceptionHandler;

public abstract class FileImporter
implements Comparable<FileImporter> {
    public final ExtensionFileFilter filter;
    private boolean enabled;
    protected final EnumSet<Options> options = EnumSet.noneOf(Options.class);

    protected FileImporter(ExtensionFileFilter filter) {
        this.filter = filter;
        this.enabled = true;
    }

    public boolean acceptFile(File pathname) {
        return this.filter.acceptName(pathname.getName());
    }

    public boolean isBatchImporter() {
        return false;
    }

    public void importData(File file, ProgressMonitor progressMonitor) throws IOException, IllegalDataException {
        throw new IOException(I18n.tr("Could not import ''{0}''.", file.getName()));
    }

    public void importData(List<File> files, ProgressMonitor progressMonitor) throws IOException, IllegalDataException {
        throw new IOException(I18n.tr("Could not import files.", new Object[0]));
    }

    public boolean importDataHandleExceptions(File f, ProgressMonitor progressMonitor) {
        try {
            Stopwatch stopwatch = Stopwatch.createStarted();
            String message = "Open file: " + f.getAbsolutePath() + " (" + f.length() + " bytes)";
            Logging.info(message);
            this.importData(f, progressMonitor);
            Logging.info(stopwatch.toString(message));
            return true;
        }
        catch (IllegalStateException | IllegalDataException e) {
            Throwable cause = e.getCause();
            if (cause instanceof ImportCancelException) {
                FileImporter.displayCancel(cause);
            } else {
                FileImporter.displayError(f, e);
            }
            return false;
        }
        catch (IOException e) {
            FileImporter.displayError(f, e);
            return false;
        }
        catch (LinkageError | RuntimeException e) {
            BugReportExceptionHandler.handleException(e);
            return false;
        }
    }

    private static void displayError(File f, Exception e) {
        Logging.error(e);
        HelpAwareOptionPane.showMessageDialogInEDT(MainApplication.getMainFrame(), I18n.tr("<html>Could not read file ''{0}''.<br>Error is:<br>{1}</html>", f.getName(), Utils.escapeReservedCharactersHTML(e.getMessage())), I18n.tr("Error", new Object[0]), 0, null);
    }

    private static void displayCancel(Throwable t) {
        GuiHelper.runInEDTAndWait(() -> {
            Notification note = new Notification(t.getMessage());
            note.setIcon(1);
            note.setDuration(Notification.TIME_SHORT);
            note.show();
        });
    }

    public boolean importDataHandleExceptions(List<File> files, ProgressMonitor progressMonitor) {
        try {
            Logging.info("Open " + files.size() + " files");
            this.importData(files, progressMonitor);
            return true;
        }
        catch (IOException | IllegalDataException e) {
            Logging.error(e);
            HelpAwareOptionPane.showMessageDialogInEDT(MainApplication.getMainFrame(), I18n.tr("<html>Could not read files.<br>Error is:<br>{0}</html>", Utils.escapeReservedCharactersHTML(e.getMessage())), I18n.tr("Error", new Object[0]), 0, null);
            return false;
        }
    }

    public double getPriority() {
        return 0.0;
    }

    @Override
    public int compareTo(FileImporter other) {
        return Double.compare(this.getPriority(), other.getPriority());
    }

    public final boolean isEnabled() {
        return this.enabled;
    }

    public final void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public final void setOptions(Options[] options) {
        this.options.clear();
        if (options != null) {
            Stream.of(options).filter(Objects::nonNull).forEach(this.options::add);
        }
    }
}

