/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.engine;

import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.jcs3.engine.CacheElement;
import org.apache.commons.jcs3.engine.behavior.ICacheElementSerialized;
import org.apache.commons.jcs3.engine.behavior.IElementAttributes;

public class CacheElementSerialized<K, V>
extends CacheElement<K, V>
implements ICacheElementSerialized<K, V> {
    private static final long serialVersionUID = -7265084818647601874L;
    private final byte[] serializedValue;

    public CacheElementSerialized(String cacheNameArg, K keyArg, byte[] serializedValueArg, IElementAttributes elementAttributesArg) {
        super(cacheNameArg, keyArg, null, elementAttributesArg);
        this.serializedValue = serializedValueArg;
    }

    @Override
    public byte[] getSerializedValue() {
        return this.serializedValue;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CacheElementSerialized)) {
            return false;
        }
        CacheElementSerialized other = (CacheElementSerialized)obj;
        return Objects.equals(this.getKey(), other.getKey());
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("\n CacheElementSerialized: ");
        buf.append("\n CacheName = [" + this.getCacheName() + "]");
        buf.append("\n Key = [" + this.getKey() + "]");
        buf.append("\n SerializedValue = " + Arrays.toString(this.getSerializedValue()));
        buf.append("\n ElementAttributes = " + this.getElementAttributes());
        return buf.toString();
    }
}

