/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint.mapcss;

import java.awt.Color;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.CRC32;
import org.openstreetmap.josm.data.coor.ILatLon;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.GpxDistance;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.SimplePrimitiveId;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.search.SearchCompiler;
import org.openstreetmap.josm.data.osm.search.SearchParseError;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.mappaint.Cascade;
import org.openstreetmap.josm.gui.mappaint.Environment;
import org.openstreetmap.josm.gui.mappaint.MapPaintStyles;
import org.openstreetmap.josm.gui.mappaint.mapcss.ExpressionFactory;
import org.openstreetmap.josm.io.XmlWriter;
import org.openstreetmap.josm.tools.AlphanumComparator;
import org.openstreetmap.josm.tools.ColorHelper;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.RightAndLefthandTraffic;
import org.openstreetmap.josm.tools.RotationAngle;
import org.openstreetmap.josm.tools.StreamUtils;
import org.openstreetmap.josm.tools.Territories;
import org.openstreetmap.josm.tools.Utils;

public final class Functions {
    private Functions() {
    }

    public static Object eval(Object o) {
        return o;
    }

    public static double plus(double a, double b) {
        return a + b;
    }

    public static double minus(double a, double b) {
        return a - b;
    }

    public static double times(double a, double b) {
        return a * b;
    }

    public static double divided_by(double a, double b) {
        return a / b;
    }

    public static float mod(float a, float b) {
        return a % b;
    }

    public static List<Object> list(Environment ignored, Object ... args) {
        return Arrays.asList(args);
    }

    public static Integer count(List<?> lst) {
        return lst.size();
    }

    @ExpressionFactory.NullableArguments
    public static Object any(Environment ignored, Object ... args) {
        return Utils.firstNonNull(args);
    }

    public static Object get(List<?> lst, float n) {
        int idx = Math.round(n);
        if (idx >= 0 && idx < lst.size()) {
            return lst.get(idx);
        }
        return null;
    }

    public static List<String> split(String sep, String toSplit) {
        return Arrays.asList(toSplit.split(Pattern.quote(sep), -1));
    }

    public static Color rgb(float r, float g, float b) {
        try {
            return new Color(r, g, b);
        }
        catch (IllegalArgumentException e) {
            Logging.trace(e);
            return null;
        }
    }

    public static Color rgba(float r, float g, float b, float alpha) {
        try {
            return new Color(r, g, b, alpha);
        }
        catch (IllegalArgumentException e) {
            Logging.trace(e);
            return null;
        }
    }

    public static Color hsb_color(float h, float s, float b) {
        try {
            return Color.getHSBColor(h, s, b);
        }
        catch (IllegalArgumentException e) {
            Logging.trace(e);
            return null;
        }
    }

    public static Color html2color(String html) {
        return ColorHelper.html2color(html);
    }

    public static String color2html(Color c) {
        return ColorHelper.color2html(c);
    }

    public static float red(Color c) {
        return ColorHelper.int2float(c.getRed()).floatValue();
    }

    public static float green(Color c) {
        return ColorHelper.int2float(c.getGreen()).floatValue();
    }

    public static float blue(Color c) {
        return ColorHelper.int2float(c.getBlue()).floatValue();
    }

    public static float alpha(Color c) {
        return ColorHelper.int2float(c.getAlpha()).floatValue();
    }

    @ExpressionFactory.NullableArguments
    public static String concat(Environment ignored, Object ... args) {
        return Arrays.stream(args).filter(Objects::nonNull).map(String::valueOf).collect(Collectors.joining());
    }

    @ExpressionFactory.NullableArguments
    public static String join(Environment ignored, String ... args) {
        return String.join((CharSequence)args[0], Arrays.asList(args).subList(1, args.length));
    }

    public static String join_list(String separator, List<String> values) {
        return String.join((CharSequence)separator, values);
    }

    public static Object prop(Environment env, String key) {
        return Functions.prop(env, key, null);
    }

    public static Object prop(Environment env, String key, String layer) {
        return env.getCascade(layer).get(key);
    }

    public static Boolean is_prop_set(Environment env, String key) {
        return Functions.is_prop_set(env, key, null);
    }

    public static Boolean is_prop_set(Environment env, String key, String layer) {
        return env.getCascade(layer).containsKey(key);
    }

    public static String tag(Environment env, String key) {
        return env.osm == null ? null : env.osm.get(key);
    }

    public static List<String> tag_regex(Environment env, String keyRegex) {
        return Functions.tag_regex(env, keyRegex, "");
    }

    public static List<String> tag_regex(Environment env, String keyRegex, String flags) {
        if (env.osm == null) {
            return Collections.emptyList();
        }
        int f = Functions.parse_regex_flags(flags);
        Pattern compiled = Pattern.compile(keyRegex, f);
        return env.osm.getKeys().entrySet().stream().filter(object -> compiled.matcher((CharSequence)object.getKey()).find()).map(Map.Entry::getValue).collect(Collectors.toList());
    }

    private static int parse_regex_flags(String flags) {
        int f = 0;
        if (flags.contains("i")) {
            f |= 2;
        }
        if (flags.contains("s")) {
            f |= 0x20;
        }
        if (flags.contains("m")) {
            f |= 8;
        }
        return f;
    }

    public static String parent_tag(Environment env, String key) {
        if (env.parent == null) {
            if (env.osm != null) {
                return env.osm.getReferrers().stream().map(parent -> parent.get(key)).filter(Objects::nonNull).findFirst().orElse(null);
            }
            return null;
        }
        return env.parent.get(key);
    }

    public static List<String> parent_tags(Environment env, String key) {
        if (env.parent == null) {
            if (env.osm != null) {
                return env.osm.getReferrers().stream().map(parent -> parent.get(key)).filter(Objects::nonNull).distinct().sorted(AlphanumComparator.getInstance()).collect(StreamUtils.toUnmodifiableList());
            }
            return Collections.emptyList();
        }
        return Collections.singletonList(env.parent.get(key));
    }

    public static Double parent_way_angle(Environment env) {
        if (env.osm instanceof Node && env.parent instanceof Way) {
            return RotationAngle.WayDirectionRotationAngle.getRotationAngleForNodeOnWay((Node)env.osm, (Way)env.parent);
        }
        return null;
    }

    public static String child_tag(Environment env, String key) {
        return env.child == null ? null : env.child.get(key);
    }

    public static Long parent_osm_id(Environment env) {
        return env.parent == null ? null : Long.valueOf(env.parent.getUniqueId());
    }

    @ExpressionFactory.NullableArguments
    public static List<IPrimitive> parent_osm_primitives(Environment env, String key, String keyValue) {
        if (env.parent == null) {
            if (env.osm != null) {
                ArrayList<IPrimitive> parents = new ArrayList<IPrimitive>();
                for (IPrimitive iPrimitive : env.osm.getReferrers()) {
                    if (key != null && iPrimitive.get(key) == null || keyValue != null && !Functions.regexp_test(keyValue, iPrimitive.get(key))) continue;
                    parents.add(iPrimitive);
                }
                return Collections.unmodifiableList(parents);
            }
            return Collections.emptyList();
        }
        return Collections.singletonList(env.parent);
    }

    @ExpressionFactory.NullableArguments
    public static List<IPrimitive> parent_osm_primitives(Environment env, String key) {
        return Functions.parent_osm_primitives(env, key, null);
    }

    public static List<IPrimitive> parent_osm_primitives(Environment env) {
        return Functions.parent_osm_primitives(env, null, null);
    }

    public static List<String> convert_primitives_to_string(Iterable<PrimitiveId> primitives) {
        ArrayList<String> primitiveStrings = new ArrayList<String>(primitives instanceof Collection ? ((Collection)primitives).size() : 0);
        for (PrimitiveId primitive : primitives) {
            primitiveStrings.add(Functions.convert_primitive_to_string(primitive));
        }
        return primitiveStrings;
    }

    public static String convert_primitive_to_string(PrimitiveId primitive) {
        return SimplePrimitiveId.toSimpleId(primitive);
    }

    public static double gpx_distance(Environment env) {
        if (env.osm instanceof OsmPrimitive) {
            return MainApplication.getLayerManager().getAllGpxData().stream().mapToDouble(gpx -> GpxDistance.getLowestDistance((OsmPrimitive)env.osm, gpx)).min().orElse(Double.MAX_VALUE);
        }
        return Double.MAX_VALUE;
    }

    public static boolean has_tag_key(Environment env, String key) {
        return env.osm != null && env.osm.hasKey(key);
    }

    public static Float index(Environment env) {
        if (env.index == null) {
            return null;
        }
        return Float.valueOf((float)env.index.intValue() + 1.0f);
    }

    public static List<String> sort(Environment ignored, String ... sortables) {
        Arrays.parallelSort((Comparable[])sortables);
        return Arrays.asList(sortables);
    }

    public static List<String> sort_list(List<String> sortables) {
        Collections.sort(sortables);
        return sortables;
    }

    public static List<String> uniq(Environment ignored, String ... values) {
        return Functions.uniq_list(Arrays.asList(values));
    }

    public static List<String> uniq_list(List<String> values) {
        return values.stream().distinct().collect(Collectors.toList());
    }

    public static String role(Environment env) {
        return env.getRole();
    }

    public static int count_roles(Environment env, String ... roles) {
        int rValue = 0;
        if (env.osm instanceof Relation) {
            List<String> roleList = Arrays.asList(roles);
            Relation rel = (Relation)env.osm;
            rValue = (int)rel.getMembers().stream().filter(member -> roleList.contains(member.getRole())).count();
        }
        return rValue;
    }

    public static Float areasize(Environment env) {
        Double area = Geometry.computeArea(env.osm);
        return area == null ? null : Float.valueOf(area.floatValue());
    }

    public static Float waylength(Environment env) {
        if (env.osm instanceof Way) {
            return Float.valueOf((float)((Way)env.osm).getLength());
        }
        return null;
    }

    public static boolean not(boolean b) {
        return !b;
    }

    public static boolean greater_equal(float a, float b) {
        return a >= b;
    }

    public static boolean less_equal(float a, float b) {
        return a <= b;
    }

    public static boolean greater(float a, float b) {
        return a > b;
    }

    public static boolean less(float a, float b) {
        return a < b;
    }

    public static double degree_to_radians(double degree) {
        return Utils.toRadians(degree);
    }

    public static Double cardinal_to_radians(String cardinal) {
        try {
            return RotationAngle.parseCardinalRotation(cardinal);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Logging.trace(illegalArgumentException);
            return null;
        }
    }

    public static boolean equal(Object a, Object b) {
        if (a.getClass() == b.getClass()) {
            return a.equals(b);
        }
        if (a.equals(Cascade.convertTo(b, a.getClass()))) {
            return true;
        }
        return b.equals(Cascade.convertTo(a, b.getClass()));
    }

    public static boolean not_equal(Object a, Object b) {
        return !Functions.equal(a, b);
    }

    public static Boolean JOSM_search(Environment env, String searchStr) {
        SearchCompiler.Match m;
        if (env.osm == null) {
            return null;
        }
        try {
            m = SearchCompiler.compile(searchStr);
        }
        catch (SearchParseError ex) {
            Logging.trace(ex);
            return null;
        }
        return m.match(env.osm);
    }

    public static String JOSM_pref(Environment env, String key, String def) {
        return MapPaintStyles.getStyles().getPreferenceCached(env != null ? env.source : null, key, def);
    }

    public static boolean regexp_test(String pattern, String target) {
        return Pattern.matches(pattern, target);
    }

    public static boolean regexp_test(String pattern, String target, String flags) {
        int f = Functions.parse_regex_flags(flags);
        return Pattern.compile(pattern, f).matcher(target).matches();
    }

    public static List<String> regexp_match(String pattern, String target, String flags) {
        int f = Functions.parse_regex_flags(flags);
        return Utils.getMatches(Pattern.compile(pattern, f).matcher(target));
    }

    public static List<String> regexp_match(String pattern, String target) {
        return Utils.getMatches(Pattern.compile(pattern).matcher(target));
    }

    public static long osm_id(Environment env) {
        return env.osm != null ? env.osm.getUniqueId() : 0L;
    }

    public static String osm_user_name(Environment env) {
        return env.osm != null ? env.osm.getUser().getName() : null;
    }

    public static long osm_user_id(Environment env) {
        return env.osm != null ? env.osm.getUser().getId() : 0L;
    }

    public static int osm_version(Environment env) {
        return env.osm != null ? env.osm.getVersion() : 0;
    }

    public static int osm_changeset_id(Environment env) {
        return env.osm != null ? env.osm.getChangesetId() : 0;
    }

    public static int osm_timestamp(Environment env) {
        return env.osm != null ? env.osm.getRawTimestamp() : 0;
    }

    @ExpressionFactory.NullableArguments
    public static String tr(Environment ignored, String ... args) {
        String text = args[0];
        System.arraycopy(args, 1, args, 0, args.length - 1);
        return I18n.tr(text, args);
    }

    public static String substring(String s, float begin) {
        return s == null ? null : s.substring((int)begin);
    }

    public static String substring(String s, float begin, float end) {
        return s == null ? null : s.substring((int)begin, (int)end);
    }

    public static String replace(String s, String target, String replacement) {
        return s == null ? null : s.replace(target, replacement);
    }

    public static String upper(String s) {
        return s == null ? null : s.toUpperCase(Locale.ENGLISH);
    }

    public static String lower(String s) {
        return s == null ? null : s.toLowerCase(Locale.ENGLISH);
    }

    public static String title(String str) {
        if (str == null) {
            return null;
        }
        char[] buffer = str.toCharArray();
        boolean capitalizeNext = true;
        for (int i = 0; i < buffer.length; ++i) {
            char ch = buffer[i];
            if (Character.isWhitespace(ch)) {
                capitalizeNext = true;
                continue;
            }
            if (capitalizeNext) {
                buffer[i] = Character.toTitleCase(ch);
                capitalizeNext = false;
                continue;
            }
            buffer[i] = Character.toLowerCase(ch);
        }
        return new String(buffer);
    }

    public static String trim(String s) {
        return Utils.strip(s);
    }

    public static List<String> trim_list(List<String> strings) {
        return strings.stream().map(Utils::strip).filter(str -> !str.isEmpty()).collect(Collectors.toList());
    }

    public static boolean is_similar(String string1, String string2) {
        return Utils.isSimilar(string1, string2);
    }

    public static String URL_decode(String s) {
        if (s == null) {
            return null;
        }
        try {
            return Utils.decodeUrl(s);
        }
        catch (IllegalStateException e) {
            Logging.debug(e);
            return s;
        }
    }

    public static String URL_encode(String s) {
        return s == null ? null : Utils.encodeUrl(s);
    }

    public static String XML_encode(String s) {
        return s == null ? null : XmlWriter.encode(s);
    }

    public static long CRC32_checksum(String s) {
        CRC32 cs = new CRC32();
        cs.update(s.getBytes(StandardCharsets.UTF_8));
        return cs.getValue();
    }

    public static boolean is_right_hand_traffic(Environment env) {
        LatLon center = Functions.center(env);
        if (center != null) {
            return RightAndLefthandTraffic.isRightHandTraffic(center);
        }
        return false;
    }

    public static boolean is_clockwise(Environment env) {
        if (!(env.osm instanceof Way)) {
            return false;
        }
        Way way = (Way)env.osm;
        return way.isClosed() && Geometry.isClockwise(way) || !way.isClosed() && way.getNodesCount() > 2 && Geometry.angleIsClockwise(way.getNode(0), way.getNode(1), way.lastNode());
    }

    public static boolean is_anticlockwise(Environment env) {
        if (!(env.osm instanceof Way)) {
            return false;
        }
        Way way = (Way)env.osm;
        return way.isClosed() && !Geometry.isClockwise(way) || !way.isClosed() && way.getNodesCount() > 2 && !Geometry.angleIsClockwise(way.getNode(0), way.getNode(1), way.lastNode());
    }

    @ExpressionFactory.NullableArguments
    public static Object print(Object o) {
        System.out.print(o == null ? "none" : o.toString());
        return o;
    }

    @ExpressionFactory.NullableArguments
    public static Object println(Object o) {
        System.out.println(o == null ? "none" : o.toString());
        return o;
    }

    public static int number_of_tags(Environment env) {
        return env.osm != null ? env.osm.getNumKeys() : 0;
    }

    public static Object setting(Environment env, String key) {
        return env.source != null ? env.source.settingValues.get(key) : null;
    }

    public static LatLon center(Environment env) {
        if (env.osm instanceof ILatLon) {
            return new LatLon(((ILatLon)((Object)env.osm)).lat(), ((ILatLon)((Object)env.osm)).lon());
        }
        if (env.osm != null) {
            return env.osm.getBBox().getCenter();
        }
        return null;
    }

    public static boolean inside(Environment env, String codes) {
        return Arrays.stream(codes.toUpperCase(Locale.ENGLISH).split(",", -1)).anyMatch(code -> Territories.isIso3166Code(code.trim(), Functions.center(env)));
    }

    public static boolean outside(Environment env, String codes) {
        return !Functions.inside(env, codes);
    }

    public static boolean at(Environment env, double lat, double lon) {
        LatLon center = Functions.center(env);
        if (center != null) {
            return new LatLon(lat, lon).equalsEpsilon(center, 1.0E-7);
        }
        return false;
    }

    public static boolean to_boolean(String value) {
        return Boolean.parseBoolean(value);
    }

    public static byte to_byte(String value) {
        return Byte.parseByte(value);
    }

    public static short to_short(String value) {
        return Short.parseShort(value);
    }

    public static int to_int(String value) {
        return Integer.parseInt(value);
    }

    public static long to_long(String value) {
        return Long.parseLong(value);
    }

    public static float to_float(String value) {
        return Float.parseFloat(value);
    }

    public static double to_double(String value) {
        return Double.parseDouble(value);
    }
}

