/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public class ChangesetDataSet {
    private final Map<PrimitiveId, Object> entryMap = new HashMap<PrimitiveId, Object>();

    public void put(HistoryOsmPrimitive primitive, ChangesetModificationType cmt) {
        ChangesetDataSetEntry[] entries;
        CheckParameterUtil.ensureParameterNotNull(primitive, "primitive");
        CheckParameterUtil.ensureParameterNotNull((Object)cmt, "cmt");
        DefaultChangesetDataSetEntry csEntry = new DefaultChangesetDataSetEntry(cmt, primitive);
        PrimitiveId pid = primitive.getPrimitiveId();
        Object val = this.entryMap.computeIfAbsent(pid, k -> csEntry);
        if (val == csEntry) {
            return;
        }
        if (val instanceof ChangesetDataSetEntry) {
            entries = new ChangesetDataSetEntry[2];
            entries[0] = (ChangesetDataSetEntry)val;
            if (primitive.getVersion() <= entries[0].getPrimitive().getVersion()) {
                throw new IllegalArgumentException(I18n.tr("Changeset {0}: Unexpected order of versions for {1}: v{2} is not higher than v{3}", String.valueOf(primitive.getChangesetId()), pid, primitive.getVersion(), entries[0].getPrimitive().getVersion()));
            }
        } else {
            entries = (ChangesetDataSetEntry[])val;
        }
        if (entries[1] != null) {
            Logging.info("Changeset {0}: Change of {1} v{2} is replaced by version v{3}", String.valueOf(primitive.getChangesetId()), pid, entries[1].getPrimitive().getVersion(), primitive.getVersion());
        }
        entries[1] = csEntry;
        this.entryMap.put(pid, entries);
    }

    public boolean contains(PrimitiveId id) {
        if (id == null) {
            return false;
        }
        return this.entryMap.containsKey(id);
    }

    public ChangesetModificationType getModificationType(PrimitiveId id) {
        ChangesetDataSetEntry e = this.getLastEntry(id);
        return e != null ? e.getModificationType() : null;
    }

    public boolean isCreated(PrimitiveId id) {
        ChangesetDataSetEntry e = this.getFirstEntry(id);
        return e != null && e.getModificationType() == ChangesetModificationType.CREATED;
    }

    public boolean isUpdated(PrimitiveId id) {
        ChangesetDataSetEntry e = this.getLastEntry(id);
        return e != null && e.getModificationType() == ChangesetModificationType.UPDATED;
    }

    public boolean isDeleted(PrimitiveId id) {
        ChangesetDataSetEntry e = this.getLastEntry(id);
        return e != null && e.getModificationType() == ChangesetModificationType.DELETED;
    }

    public int size() {
        return this.entryMap.size();
    }

    public HistoryOsmPrimitive getPrimitive(PrimitiveId id) {
        ChangesetDataSetEntry e = this.getLastEntry(id);
        return e != null ? e.getPrimitive() : null;
    }

    public Set<PrimitiveId> getIds() {
        return Collections.unmodifiableSet(this.entryMap.keySet());
    }

    public ChangesetDataSetEntry getFirstEntry(PrimitiveId id) {
        return this.getEntry(id, 0);
    }

    public ChangesetDataSetEntry getLastEntry(PrimitiveId id) {
        return this.getEntry(id, 1);
    }

    private ChangesetDataSetEntry getEntry(PrimitiveId id, int n) {
        if (id == null) {
            return null;
        }
        Object val = this.entryMap.get(id);
        if (val == null) {
            return null;
        }
        if (val instanceof ChangesetDataSetEntry[]) {
            ChangesetDataSetEntry[] entries = (ChangesetDataSetEntry[])val;
            return entries[n];
        }
        return (ChangesetDataSetEntry)val;
    }

    public Iterator<ChangesetDataSetEntry> iterator() {
        return new DefaultIterator(this.entryMap);
    }

    public static class DefaultChangesetDataSetEntry
    implements ChangesetDataSetEntry {
        private final ChangesetModificationType modificationType;
        private final HistoryOsmPrimitive primitive;

        public DefaultChangesetDataSetEntry(ChangesetModificationType modificationType, HistoryOsmPrimitive primitive) {
            this.modificationType = modificationType;
            this.primitive = primitive;
        }

        @Override
        public ChangesetModificationType getModificationType() {
            return this.modificationType;
        }

        @Override
        public HistoryOsmPrimitive getPrimitive() {
            return this.primitive;
        }

        public String toString() {
            return this.modificationType.toString() + " " + this.primitive.toString();
        }
    }

    public static enum ChangesetModificationType {
        CREATED,
        UPDATED,
        DELETED;

    }

    public static interface ChangesetDataSetEntry {
        public ChangesetModificationType getModificationType();

        public HistoryOsmPrimitive getPrimitive();
    }

    private static class DefaultIterator
    implements Iterator<ChangesetDataSetEntry> {
        private final Iterator<Map.Entry<PrimitiveId, Object>> typeIterator;

        DefaultIterator(Map<PrimitiveId, Object> entryMap) {
            this.typeIterator = entryMap.entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.typeIterator.hasNext();
        }

        @Override
        public ChangesetDataSetEntry next() {
            ChangesetDataSetEntry last;
            Map.Entry<PrimitiveId, Object> next = this.typeIterator.next();
            Object val = next.getValue();
            if (val instanceof ChangesetDataSetEntry[]) {
                ChangesetDataSetEntry[] entries = (ChangesetDataSetEntry[])val;
                last = entries[1];
            } else {
                last = (ChangesetDataSetEntry)val;
            }
            return new DefaultChangesetDataSetEntry(last.getModificationType(), last.getPrimitive());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

