/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.tools.HttpClient;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Mediawiki {
    private final String baseUrl;

    public Mediawiki(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public Optional<String> findExistingPage(List<String> pages) throws IOException, ParserConfigurationException, SAXException, XPathExpressionException {
        List distinctPages = pages.stream().distinct().collect(Collectors.toList());
        URL url = new URL(this.baseUrl + "/w/api.php?action=query&format=xml&titles=" + distinctPages.stream().map(Utils::encodeUrl).collect(Collectors.joining(Utils.encodeUrl("|"))));
        Document document = this.getDocument(url);
        XPath xPath = XPathFactory.newInstance().newXPath();
        for (String page : distinctPages) {
            Node node;
            String normalized = xPath.evaluate("/api/query/normalized/n[@from='" + page + "']/@to", document);
            if (Utils.isEmpty(normalized)) {
                normalized = page;
            }
            if ((node = (Node)xPath.evaluate("/api/query/pages/page[@title='" + normalized + "']", document, XPathConstants.NODE)) == null || node.getAttributes().getNamedItem("missing") != null || node.getAttributes().getNamedItem("invalid") != null) continue;
            return Optional.of(page);
        }
        return Optional.empty();
    }

    private Document getDocument(URL url) throws IOException, ParserConfigurationException, SAXException {
        HttpClient.Response conn = HttpClient.create(url).connect();
        try {
            Document document;
            block9: {
                InputStream content = conn.getContent();
                try {
                    document = XmlUtils.parseSafeDOM(content);
                    if (content == null) break block9;
                }
                catch (Throwable throwable) {
                    if (content != null) {
                        try {
                            content.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                content.close();
            }
            return document;
        }
        finally {
            conn.disconnect();
        }
    }

    public void searchGeoImages(Bounds bounds, BiConsumer<String, LatLon> imageConsumer) throws IOException, ParserConfigurationException, SAXException, XPathExpressionException {
        URL url = new URL(Mediawiki.getGeoImagesUrl(this.baseUrl, bounds));
        Document document = this.getDocument(url);
        XPath xPath = XPathFactory.newInstance().newXPath();
        NodeList nodes = (NodeList)xPath.evaluate("/api/query/geosearch/gs", document, XPathConstants.NODESET);
        for (int i = 0; i < nodes.getLength(); ++i) {
            NamedNodeMap attributes = nodes.item(i).getAttributes();
            String title = attributes.getNamedItem("title").getNodeValue();
            double lat = Double.parseDouble(attributes.getNamedItem("lat").getNodeValue());
            double lon = Double.parseDouble(attributes.getNamedItem("lon").getNodeValue());
            imageConsumer.accept(title, new LatLon(lat, lon));
        }
    }

    public static String getGeoImagesUrl(String baseUrl, Bounds bounds) {
        String sep = Utils.encodeUrl("|");
        return baseUrl + "?format=xml&action=query&list=geosearch&gsnamespace=6&gslimit=500&gsprop=type" + sep + "name&gsbbox=" + bounds.getMaxLat() + sep + bounds.getMinLon() + sep + bounds.getMinLat() + sep + bounds.getMaxLon();
    }

    public static String getImageUrl(String fileBaseUrl, String filename) {
        String md5 = Utils.md5Hex(filename);
        return String.join((CharSequence)"/", Utils.strip(fileBaseUrl, "/"), md5.substring(0, 1), md5.substring(0, 2), filename);
    }
}

