/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.advanced;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.table.AbstractTableModel;
import org.openstreetmap.josm.gui.preferences.advanced.AbstractTableListEditor;
import org.openstreetmap.josm.gui.preferences.advanced.PrefEntry;
import org.openstreetmap.josm.spi.preferences.ListListSetting;
import org.openstreetmap.josm.tools.I18n;

public class ListListEditor
extends AbstractTableListEditor<List<String>> {
    private final transient List<List<String>> data;

    public ListListEditor(JComponent gui, PrefEntry entry, ListListSetting setting) {
        super((Component)gui, I18n.tr("Change list of lists setting", new Object[0]), entry);
        List orig = (List)setting.getValue();
        this.data = new ArrayList<List<String>>();
        if (orig != null) {
            for (List l : orig) {
                this.data.add(new ArrayList(l));
            }
        }
    }

    @Override
    public List<List<String>> getData() {
        return this.data;
    }

    @Override
    protected final JPanel build() {
        this.table.setTableHeader(null);
        return super.build();
    }

    @Override
    protected AbstractTableListEditor.AbstractEntryListModel newEntryListModel() {
        return new EntryListModel();
    }

    @Override
    protected AbstractTableModel newTableModel() {
        return new ListTableModel();
    }

    private class EntryListModel
    extends AbstractTableListEditor.AbstractEntryListModel {
        private EntryListModel() {
        }

        @Override
        public String getElementAt(int index) {
            return index + 1 + ": " + ListListEditor.this.data.get(index);
        }

        @Override
        public int getSize() {
            return ListListEditor.this.data.size();
        }

        @Override
        public void add() {
            ListListEditor.this.data.add(new ArrayList());
            this.fireIntervalAdded(this, this.getSize() - 1, this.getSize() - 1);
        }

        @Override
        public void remove(int idx) {
            ListListEditor.this.data.remove(idx);
            this.fireIntervalRemoved(this, idx, idx);
        }
    }

    private class ListTableModel
    extends AbstractTableModel {
        private ListTableModel() {
        }

        private List<String> data() {
            return ListListEditor.this.entryIdx == null ? Collections.emptyList() : (List)ListListEditor.this.data.get(ListListEditor.this.entryIdx);
        }

        private int size() {
            return this.data().size();
        }

        @Override
        public int getRowCount() {
            return ListListEditor.this.entryIdx == null ? 0 : this.size() + 1;
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public Object getValueAt(int row, int column) {
            return this.size() == row ? "" : this.data().get(row);
        }

        @Override
        public void setValueAt(Object o, int row, int column) {
            String s = (String)o;
            if (row == this.size()) {
                this.data().add(s);
                this.fireTableRowsInserted(row + 1, row + 1);
            } else {
                this.data().set(row, s);
                this.fireTableCellUpdated(row, column);
            }
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return true;
        }
    }
}

