/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.plugin;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.gui.preferences.plugin.PluginListPanel;
import org.openstreetmap.josm.gui.preferences.plugin.PluginPreferencesModel;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class PluginCheckBox
extends JCheckBox
implements ActionListener {
    private final transient PluginInformation pi;
    private final PluginListPanel panel;
    private final transient PluginPreferencesModel ppModel;

    PluginCheckBox(PluginInformation pi, boolean selected, PluginListPanel panel, PluginPreferencesModel ppModel) {
        this.pi = pi;
        this.panel = panel;
        this.ppModel = ppModel;
        this.setSelected(selected);
        this.setToolTipText(PluginListPanel.formatCheckboxTooltipText(pi));
        this.addActionListener(this);
    }

    protected void selectRequiredPlugins(PluginInformation info) {
        if (info != null && info.requires != null) {
            for (String s : info.getRequiredPlugins()) {
                if (this.ppModel.isSelectedPlugin(s)) continue;
                this.ppModel.setPluginSelected(s, true);
                this.selectRequiredPlugins(this.ppModel.getPluginInformation(s));
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Set<String> otherPlugins;
        this.ppModel.setPluginSelected(this.pi.getName(), this.isSelected());
        if (this.isSelected() && this.pi.requires != null) {
            this.selectRequiredPlugins(this.pi);
            PluginHandler.checkRequiredPluginsPreconditions(this.panel, this.ppModel.getAvailablePlugins(), this.pi, false);
        } else if (!this.isSelected() && !(otherPlugins = this.ppModel.getAvailablePlugins().stream().filter(p -> !p.equals(this.pi) && p.requires != null && this.ppModel.isSelectedPlugin(p.getName())).filter(p -> p.getRequiredPlugins().stream().anyMatch(s -> s.equals(this.pi.getName()) || s.equals(this.pi.provides))).map(PluginInformation::getName).collect(Collectors.toSet())).isEmpty()) {
            PluginCheckBox.alertPluginStillRequired(this.panel, this.pi.getName(), otherPlugins);
        }
    }

    private static void alertPluginStillRequired(Component parent, String plugin, Set<String> otherPlugins) {
        StringBuilder sb = new StringBuilder("<html>").append(I18n.trn("Plugin {0} is still required by this plugin:", "Plugin {0} is still required by these {1} plugins:", otherPlugins.size(), Utils.escapeReservedCharactersHTML(plugin), otherPlugins.size())).append(Utils.joinAsHtmlUnorderedList(otherPlugins)).append("</html>");
        JOptionPane.showMessageDialog(parent, sb.toString(), I18n.tr("Warning", new Object[0]), 2);
    }
}

