/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import org.openstreetmap.josm.actions.ExpertToggleAction;
import org.openstreetmap.josm.actions.ToggleAction;
import org.openstreetmap.josm.actions.mapmode.DrawAction;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class ViewportFollowToggleAction
extends ToggleAction {
    public static final BooleanProperty PROP_NOTIFICATION = new BooleanProperty("viewportfollow.notification", true);

    public ViewportFollowToggleAction() {
        super(I18n.tr("Viewport Following", new Object[0]), "viewport-follow", I18n.tr("Enable/disable automatic moving of the map view to last placed node", new Object[0]), Shortcut.registerShortcut("menu:view:viewportfollow", I18n.tr("View: {0}", I18n.tr("Viewport Following", new Object[0])), 70, 5009), true);
        this.setHelpId(HelpUtil.ht("/Action/ViewportFollowing"));
        this.setSelected(DrawAction.VIEWPORT_FOLLOWING.get());
        this.notifySelectedState();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!ExpertToggleAction.isExpert()) {
            return;
        }
        this.toggleSelectedState(e);
        DrawAction.VIEWPORT_FOLLOWING.put(this.isSelected());
        if (!this.getShortcut().getKeyText().isEmpty() && PROP_NOTIFICATION.get().booleanValue()) {
            String msg = this.isSelected() ? I18n.tr("Viewport following is enabled, press {0} to disable it", this.getShortcut().getKeyText()) : I18n.tr("Viewport following is disabled", new Object[0]);
            GuiHelper.runInEDT(() -> new Notification(msg).show());
        }
        this.notifySelectedState();
    }

    @Override
    protected boolean listenToSelectionChange() {
        return false;
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(this.getLayerManager().getEditDataSet() != null);
    }
}

