/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.oauth;

import java.awt.Component;
import java.io.IOException;
import org.openstreetmap.josm.data.oauth.OAuthParameters;
import org.openstreetmap.josm.data.oauth.OAuthToken;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.oauth.OsmOAuthAuthorizationClient;
import org.openstreetmap.josm.gui.oauth.OsmOAuthAuthorizationException;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.io.OsmTransferCanceledException;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.xml.sax.SAXException;

public class RetrieveAccessTokenTask
extends PleaseWaitRunnable {
    private boolean canceled;
    private OAuthToken accessToken;
    private final OAuthParameters parameters;
    private OsmOAuthAuthorizationClient client;
    private final OAuthToken requestToken;
    private final Component parent;

    public RetrieveAccessTokenTask(Component parent, OAuthParameters parameters, OAuthToken requestToken) {
        super(parent, I18n.tr("Retrieving OAuth Access Token...", new Object[0]), false);
        CheckParameterUtil.ensureParameterNotNull(parameters, "parameters");
        CheckParameterUtil.ensureParameterNotNull(requestToken, "requestToken");
        this.parameters = parameters;
        this.requestToken = requestToken;
        this.parent = parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void cancel() {
        this.canceled = true;
        RetrieveAccessTokenTask retrieveAccessTokenTask = this;
        synchronized (retrieveAccessTokenTask) {
            if (this.client != null) {
                this.client.cancel();
            }
        }
    }

    @Override
    protected void finish() {
    }

    protected void alertRetrievingAccessTokenFailed() {
        HelpAwareOptionPane.showOptionDialog(this.parent, I18n.tr("<html>Retrieving an OAuth Access Token from ''{0}'' failed.</html>", this.parameters.getAccessTokenUrl()), I18n.tr("Request Failed", new Object[0]), 0, HelpUtil.ht("/OAuth#NotAuthorizedException"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void realRun() throws SAXException, IOException, OsmTransferException {
        try {
            RetrieveAccessTokenTask retrieveAccessTokenTask = this;
            synchronized (retrieveAccessTokenTask) {
                this.client = new OsmOAuthAuthorizationClient(this.parameters, this.requestToken);
            }
            this.accessToken = this.client.getAccessToken(this.getProgressMonitor().createSubTaskMonitor(0, false));
        }
        catch (OsmTransferCanceledException e) {
            Logging.trace(e);
        }
        catch (OsmOAuthAuthorizationException e) {
            Logging.error(e);
            GuiHelper.runInEDT(this::alertRetrievingAccessTokenFailed);
            this.accessToken = null;
        }
        finally {
            RetrieveAccessTokenTask e = this;
            synchronized (e) {
                this.client = null;
            }
        }
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public OAuthToken getAccessToken() {
        return this.accessToken;
    }
}

