/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.validation.tests.RelationChecker;
import org.openstreetmap.josm.gui.ConditionalOptionPaneUtil;
import org.openstreetmap.josm.gui.dialogs.relation.GenericRelationEditor;
import org.openstreetmap.josm.gui.dialogs.relation.actions.AbstractRelationEditorAction;
import org.openstreetmap.josm.gui.dialogs.relation.actions.IRelationEditorActionAccess;
import org.openstreetmap.josm.gui.dialogs.relation.actions.IRelationEditorUpdateOn;
import org.openstreetmap.josm.tools.Utils;

abstract class AddFromSelectionAction
extends AbstractRelationEditorAction {
    private static final long serialVersionUID = 1L;

    protected AddFromSelectionAction(IRelationEditorActionAccess editorAccess, IRelationEditorUpdateOn ... updateOn) {
        super(editorAccess, updateOn);
    }

    protected boolean isPotentialDuplicate(OsmPrimitive primitive) {
        return this.editorAccess.getMemberTableModel().hasMembersReferringTo(Collections.singleton(primitive));
    }

    protected List<OsmPrimitive> filterConfirmedPrimitives(List<OsmPrimitive> primitives) throws GenericRelationEditor.AddAbortException {
        if (Utils.isEmpty(primitives)) {
            return primitives;
        }
        ArrayList<OsmPrimitive> ret = new ArrayList<OsmPrimitive>();
        ConditionalOptionPaneUtil.startBulkOperation("add_primitive_to_relation");
        for (OsmPrimitive primitive : primitives) {
            List<Relation> loop;
            if (primitive instanceof Relation && !(loop = RelationChecker.checkAddMember(this.editorAccess.getEditor().getRelation(), (Relation)primitive)).isEmpty() && loop.get(0).equals(loop.get(loop.size() - 1))) {
                GenericRelationEditor.warnOfCircularReferences(primitive, loop);
                continue;
            }
            if (this.isPotentialDuplicate(primitive)) {
                if (!GenericRelationEditor.confirmAddingPrimitive(primitive)) continue;
                ret.add(primitive);
                continue;
            }
            ret.add(primitive);
        }
        ConditionalOptionPaneUtil.endBulkOperation("add_primitive_to_relation");
        return ret;
    }
}

