/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging.presets;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.JLabel;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.preferences.sources.ValidatorPrefHelper;
import org.openstreetmap.josm.data.validation.OsmValidator;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.data.validation.tests.MapCSSTagChecker;
import org.openstreetmap.josm.data.validation.tests.OpeningHourTest;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPreset;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

interface TaggingPresetValidation {
    public static void validateAsync(OsmPrimitive original, JLabel validationLabel, List<Tag> changedTags) {
        OsmPrimitive primitive = TaggingPresetValidation.applyChangedTags(original, changedTags);
        MainApplication.worker.execute(() -> TaggingPresetValidation.validate(primitive, validationLabel));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void validate(OsmPrimitive primitive, JLabel validationLabel) {
        try {
            MapCSSTagChecker mapCSSTagChecker = OsmValidator.getTest(MapCSSTagChecker.class);
            OpeningHourTest openingHourTest = OsmValidator.getTest(OpeningHourTest.class);
            OsmValidator.initializeTests(Arrays.asList(mapCSSTagChecker, openingHourTest));
            ArrayList<TestError> errors = new ArrayList<TestError>();
            openingHourTest.addErrorsForPrimitive(primitive, errors);
            errors.addAll(mapCSSTagChecker.getErrorsForPrimitive(primitive, ValidatorPrefHelper.PREF_OTHER.get()));
            boolean visible = !errors.isEmpty();
            String toolTipText = "<html>" + Utils.joinAsHtmlUnorderedList(Utils.transform(errors, e -> e.getDescription() == null ? e.getMessage() : I18n.tr("{0} ({1})", e.getMessage(), e.getDescription())));
            GuiHelper.runInEDTAndWait(() -> {
                validationLabel.setVisible(visible);
                validationLabel.setToolTipText(toolTipText);
            });
        }
        catch (Exception e2) {
            Logging.warn("Failed to validate {0}", primitive);
            Logging.warn(e2);
        }
        finally {
            primitive.getDataSet().clear();
        }
    }

    public static OsmPrimitive applyChangedTags(OsmPrimitive original, List<Tag> changedTags) {
        OsmPrimitive primitive = TaggingPresetValidation.clone(original);
        new DataSet(primitive);
        Command command = TaggingPreset.createCommand(Collections.singleton(primitive), changedTags);
        if (command != null) {
            command.executeCommand();
        }
        return primitive;
    }

    public static OsmPrimitive clone(OsmPrimitive original) {
        if (original instanceof Node) {
            return new Node((Node)original);
        }
        if (original instanceof Way) {
            return new Way((Way)original, false, false);
        }
        if (original instanceof Relation) {
            return new Relation((Relation)original, false, false);
        }
        throw new IllegalStateException();
    }
}

