/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer;

import java.awt.GraphicsEnvironment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmData;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.io.AsynchronousUploadPrimitivesTask;
import org.openstreetmap.josm.gui.layer.AbstractOsmDataLayer;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.LayerManager;
import org.openstreetmap.josm.gui.layer.NoteLayer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.layer.geoimage.GeoImageLayer;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public class MainLayerManager
extends LayerManager {
    private Layer activeLayer;
    private AbstractOsmDataLayer dataLayer;
    private OsmDataLayer osmDataLayer;
    private final List<ActiveLayerChangeListener> activeLayerChangeListeners = new CopyOnWriteArrayList<ActiveLayerChangeListener>();
    private final List<LayerAvailabilityListener> layerAvailabilityListeners = new CopyOnWriteArrayList<LayerAvailabilityListener>();

    public synchronized void addActiveLayerChangeListener(ActiveLayerChangeListener listener) {
        if (this.activeLayerChangeListeners.contains(listener)) {
            throw new IllegalArgumentException("Attempted to add listener that was already in list: " + listener);
        }
        this.activeLayerChangeListeners.add(listener);
    }

    public synchronized void addAndFireActiveLayerChangeListener(ActiveLayerChangeListener listener) {
        this.addActiveLayerChangeListener(listener);
        listener.activeOrEditLayerChanged(new ActiveLayerChangeEvent(this, null, null));
    }

    public synchronized void removeActiveLayerChangeListener(ActiveLayerChangeListener listener) {
        if (!this.activeLayerChangeListeners.contains(listener)) {
            throw new IllegalArgumentException("Attempted to remove listener that was not in list: " + listener);
        }
        this.activeLayerChangeListeners.remove(listener);
    }

    public synchronized void addLayerAvailabilityListener(LayerAvailabilityListener listener) {
        if (!this.layerAvailabilityListeners.add(listener)) {
            throw new IllegalArgumentException("Attempted to add listener that was already in list: " + listener);
        }
    }

    public synchronized void removeLayerAvailabilityListener(LayerAvailabilityListener listener) {
        if (!this.layerAvailabilityListeners.remove(listener)) {
            throw new IllegalArgumentException("Attempted to remove listener that was not in list: " + listener);
        }
    }

    public void setActiveLayer(Layer layer) {
        if (layer instanceof OsmDataLayer && ((OsmDataLayer)layer).isUploadInProgress()) {
            GuiHelper.runInEDT(() -> JOptionPane.showMessageDialog(MainApplication.getMainFrame(), I18n.tr("Trying to set a read only data layer as edit layer", new Object[0]), I18n.tr("Warning", new Object[0]), 2));
        } else {
            GuiHelper.runInEDTAndWaitWithException(() -> this.realSetActiveLayer(layer));
        }
    }

    protected synchronized void realSetActiveLayer(Layer layer) {
        this.checkContainsLayer(layer);
        this.setActiveLayer(layer, false);
    }

    private void setActiveLayer(Layer layer, boolean forceEditLayerUpdate) {
        ActiveLayerChangeEvent event = new ActiveLayerChangeEvent(this, this.osmDataLayer, this.activeLayer);
        this.activeLayer = layer;
        if (this.activeLayer instanceof AbstractOsmDataLayer) {
            this.dataLayer = (AbstractOsmDataLayer)this.activeLayer;
        } else if (forceEditLayerUpdate) {
            this.dataLayer = null;
        }
        if (this.activeLayer instanceof OsmDataLayer) {
            this.osmDataLayer = (OsmDataLayer)this.activeLayer;
        } else if (forceEditLayerUpdate) {
            this.osmDataLayer = null;
        }
        this.fireActiveLayerChange(event);
    }

    private void fireActiveLayerChange(ActiveLayerChangeEvent event) {
        GuiHelper.assertCallFromEdt();
        if (event.getPreviousActiveLayer() != this.activeLayer || event.getPreviousDataLayer() != this.osmDataLayer) {
            for (ActiveLayerChangeListener l : this.activeLayerChangeListeners) {
                l.activeOrEditLayerChanged(event);
            }
        }
    }

    @Override
    protected synchronized void realAddLayer(Layer layer, boolean initialZoom) {
        if (this.getLayers().isEmpty()) {
            LayerAvailabilityEvent e = new LayerAvailabilityEvent(this, true);
            for (LayerAvailabilityListener l : this.layerAvailabilityListeners) {
                l.beforeFirstLayerAdded(e);
            }
        }
        super.realAddLayer(layer, initialZoom);
        if (layer instanceof OsmDataLayer || this.activeLayer == null) {
            this.setActiveLayer(layer);
        }
    }

    @Override
    protected Collection<Layer> realRemoveSingleLayer(Layer layer) {
        if (layer instanceof OsmDataLayer && ((OsmDataLayer)layer).isUploadInProgress()) {
            GuiHelper.runInEDT(() -> JOptionPane.showMessageDialog(MainApplication.getMainFrame(), I18n.tr("Trying to delete the layer with background upload. Please wait until the upload is finished.", new Object[0])));
            return new ArrayList<Layer>();
        }
        if (layer == this.activeLayer || layer == this.osmDataLayer) {
            Layer nextActive = this.suggestNextActiveLayer(layer);
            this.setActiveLayer(nextActive, true);
        }
        Collection<Layer> toDelete = super.realRemoveSingleLayer(layer);
        if (this.getLayers().isEmpty()) {
            LayerAvailabilityEvent e = new LayerAvailabilityEvent(this, false);
            for (LayerAvailabilityListener l : this.layerAvailabilityListeners) {
                l.afterLastLayerRemoved(e);
            }
        }
        return toDelete;
    }

    private Layer suggestNextActiveLayer(Layer except) {
        ArrayList<Layer> layersList = new ArrayList<Layer>(this.getLayers());
        layersList.remove(except);
        for (Layer layer : layersList) {
            if (!(layer instanceof OsmDataLayer)) continue;
            return layer;
        }
        if (!layersList.isEmpty()) {
            return (Layer)layersList.get(0);
        }
        return null;
    }

    public synchronized Layer getActiveLayer() {
        if (this.activeLayer instanceof OsmDataLayer) {
            if (!((OsmDataLayer)this.activeLayer).isUploadInProgress()) {
                return this.activeLayer;
            }
            return null;
        }
        return this.activeLayer;
    }

    public synchronized OsmDataLayer getEditLayer() {
        if (this.osmDataLayer != null && !this.osmDataLayer.isLocked()) {
            return this.osmDataLayer;
        }
        return null;
    }

    public synchronized OsmDataLayer getActiveDataLayer() {
        if (this.osmDataLayer != null) {
            return this.osmDataLayer;
        }
        return null;
    }

    public synchronized DataSet getEditDataSet() {
        if (this.osmDataLayer != null && !this.osmDataLayer.isLocked()) {
            return this.osmDataLayer.getDataSet();
        }
        return null;
    }

    public synchronized OsmData<?, ?, ?, ?> getActiveData() {
        if (this.dataLayer != null) {
            return this.dataLayer.getDataSet();
        }
        return null;
    }

    public synchronized DataSet getActiveDataSet() {
        if (this.osmDataLayer != null) {
            return this.osmDataLayer.getDataSet();
        }
        return null;
    }

    public NoteLayer getNoteLayer() {
        List<NoteLayer> col = this.getLayersOfType(NoteLayer.class);
        return col.isEmpty() ? null : col.get(0);
    }

    public synchronized List<Layer> getVisibleLayersInZOrder() {
        ArrayList<Layer> ret = new ArrayList<Layer>();
        boolean activeLayerDelayed = false;
        List<Layer> layers = this.getLayers();
        ListIterator<Layer> iterator = layers.listIterator(layers.size());
        while (iterator.hasPrevious()) {
            Layer l = iterator.previous();
            if (!l.isVisible()) continue;
            if (l == this.activeLayer && l instanceof OsmDataLayer) {
                activeLayerDelayed = true;
                continue;
            }
            if (activeLayerDelayed && !(l instanceof OsmDataLayer)) {
                ret.add(this.activeLayer);
                activeLayerDelayed = false;
            }
            ret.add(l);
        }
        if (activeLayerDelayed) {
            ret.add(this.activeLayer);
        }
        return ret;
    }

    public void invalidateEditLayer() {
        if (this.osmDataLayer != null) {
            this.osmDataLayer.invalidate();
        }
    }

    @Override
    protected synchronized void realResetState() {
        if (!AsynchronousUploadPrimitivesTask.getCurrentAsynchronousUploadTask().isPresent()) {
            super.realResetState();
            this.activeLayerChangeListeners.clear();
            this.layerAvailabilityListeners.clear();
        } else {
            String msg = I18n.tr("A background upload is already in progress. Cannot reset state until the upload is finished.", new Object[0]);
            Logging.warn(msg);
            if (!GraphicsEnvironment.isHeadless()) {
                GuiHelper.runInEDT(() -> JOptionPane.showMessageDialog(MainApplication.getMainFrame(), msg));
            }
        }
    }

    public synchronized void prepareLayerForUpload(OsmDataLayer layer) {
        GuiHelper.assertCallFromEdt();
        layer.setUploadInProgress();
        layer.lock();
        if (this.osmDataLayer == layer) {
            ActiveLayerChangeEvent activeLayerChangeEvent = new ActiveLayerChangeEvent(this, this.osmDataLayer, this.activeLayer);
            this.osmDataLayer = null;
            this.fireActiveLayerChange(activeLayerChangeEvent);
        }
    }

    public synchronized void processLayerAfterUpload(OsmDataLayer layer) {
        GuiHelper.assertCallFromEdt();
        layer.unlock();
        layer.unsetUploadInProgress();
        if (this.osmDataLayer == null) {
            ActiveLayerChangeEvent layerChangeEvent = new ActiveLayerChangeEvent(this, this.osmDataLayer, this.activeLayer);
            this.osmDataLayer = layer;
            this.fireActiveLayerChange(layerChangeEvent);
        }
    }

    public List<GpxData> getAllGpxData() {
        ArrayList<GpxData> result = new ArrayList<GpxData>();
        for (Layer layer : this.getLayers()) {
            if (layer instanceof GpxLayer) {
                result.add(((GpxLayer)layer).data);
                continue;
            }
            if (!(layer instanceof GeoImageLayer)) continue;
            result.add(((GeoImageLayer)layer).getFauxGpxLayer().data);
        }
        return result;
    }

    @FunctionalInterface
    public static interface ActiveLayerChangeListener {
        public void activeOrEditLayerChanged(ActiveLayerChangeEvent var1);
    }

    public static class ActiveLayerChangeEvent
    extends LayerManager.LayerManagerEvent {
        private final OsmDataLayer previousDataLayer;
        private final Layer previousActiveLayer;

        ActiveLayerChangeEvent(MainLayerManager source, OsmDataLayer previousDataLayer, Layer previousActiveLayer) {
            super(source);
            this.previousDataLayer = previousDataLayer;
            this.previousActiveLayer = previousActiveLayer;
        }

        public OsmDataLayer getPreviousDataLayer() {
            return this.previousDataLayer;
        }

        public Layer getPreviousActiveLayer() {
            return this.previousActiveLayer;
        }

        public DataSet getPreviousDataSet() {
            if (this.previousDataLayer != null) {
                return this.previousDataLayer.getDataSet();
            }
            return null;
        }

        @Override
        public MainLayerManager getSource() {
            return (MainLayerManager)super.getSource();
        }
    }

    public static class LayerAvailabilityEvent
    extends LayerManager.LayerManagerEvent {
        private final boolean hasLayers;

        LayerAvailabilityEvent(LayerManager source, boolean hasLayers) {
            super(source);
            this.hasLayers = hasLayers;
        }

        public boolean hasLayers() {
            return this.hasLayers;
        }
    }

    public static interface LayerAvailabilityListener {
        public void beforeFirstLayerAdded(LayerAvailabilityEvent var1);

        public void afterLastLayerRemoved(LayerAvailabilityEvent var1);
    }
}

