/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io.importexport;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.io.importexport.FileImporter;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.io.CachedFile;
import org.openstreetmap.josm.io.Compression;
import org.openstreetmap.josm.io.GeoJSONReader;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public class GeoJSONImporter
extends FileImporter {
    private static final ExtensionFileFilter FILE_FILTER = ExtensionFileFilter.newFilterWithArchiveExtensions("geojson", "geojson", I18n.tr("GeoJSON file", new Object[0]) + " (*.geojson, *.geojson.gz, *.geojson.bz2, *.geojson.xz, *.geojson.zip)", ExtensionFileFilter.AddArchiveExtension.NONE, Arrays.asList("gz", "bz", "bz2", "xz", "zip"));

    public GeoJSONImporter() {
        super(FILE_FILTER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void importData(File file, ProgressMonitor progressMonitor) {
        progressMonitor.beginTask(I18n.tr("Loading json file\u2026", new Object[0]));
        progressMonitor.setTicksCount(2);
        Logging.info("Parsing GeoJSON: {0}", file.getAbsolutePath());
        try (InputStream fileInputStream = Compression.getUncompressedFileInputStream(file);){
            DataSet data = GeoJSONReader.parseDataSet(fileInputStream, progressMonitor);
            progressMonitor.worked(1);
            MainApplication.getLayerManager().addLayer(new OsmDataLayer(data, file.getName(), file));
        }
        catch (IOException | IllegalArgumentException | IllegalDataException e) {
            Logging.error("Error while reading json file!");
            Logging.error(e);
            GuiHelper.runInEDT(() -> JOptionPane.showMessageDialog(null, I18n.tr("Error loading geojson file {0}", file.getAbsolutePath()), I18n.tr("Error", new Object[0]), 2));
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    public DataSet parseDataSet(String source) throws IOException, IllegalDataException {
        try (CachedFile cf = new CachedFile(source);){
            InputStream fileInputStream = Compression.getUncompressedFileInputStream(cf.getFile());
            DataSet dataSet = GeoJSONReader.parseDataSet(fileInputStream, NullProgressMonitor.INSTANCE);
            return dataSet;
        }
    }
}

