/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.dialogs.properties.PresetListPanel;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.tagging.TagCellEditor;
import org.openstreetmap.josm.gui.tagging.TagEditorModel;
import org.openstreetmap.josm.gui.tagging.TagTable;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionList;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionManager;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetHandler;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public class TagEditorPanel
extends JPanel {
    private TagEditorModel model;
    private final TagTable tagTable;
    private PresetListPanel presetListPanel;
    private final transient TaggingPresetHandler presetHandler;

    protected JPanel buildTagTableEditorPanel() {
        JPanel pnl = new JPanel(new BorderLayout());
        pnl.add((Component)new JScrollPane(this.tagTable), "Center");
        if (this.presetHandler != null) {
            this.presetListPanel = new PresetListPanel();
            if (Config.getPref().getBoolean("relation.editor.presets.visible", true)) {
                pnl.add((Component)this.presetListPanel, "North");
            }
        }
        return pnl;
    }

    public void setNextFocusComponent(Component nextFocusComponent) {
        this.tagTable.setNextFocusComponent(nextFocusComponent);
    }

    protected JPanel buildButtonsPanel() {
        JPanel pnl = new JPanel();
        pnl.setLayout(new BoxLayout(pnl, 1));
        this.buildButton(pnl, this.tagTable.getAddAction());
        this.buildButton(pnl, this.tagTable.getDeleteAction());
        this.buildButton(pnl, this.tagTable.getPasteAction());
        return pnl;
    }

    private void buildButton(JPanel pnl, AbstractAction action) {
        JButton btn = new JButton(action);
        pnl.add(btn);
        btn.setMargin(new Insets(0, 0, 0, 0));
        this.tagTable.addComponentNotStoppingCellEditing(btn);
    }

    public AbstractAction getPasteAction() {
        return this.tagTable.getPasteAction();
    }

    protected final void build() {
        this.setLayout(new GridBagLayout());
        JPanel tablePanel = this.buildTagTableEditorPanel();
        JPanel buttonPanel = this.buildButtonsPanel();
        GridBagConstraints gc = new GridBagConstraints();
        gc.fill = 3;
        gc.weightx = 0.0;
        gc.weighty = 1.0;
        gc.anchor = 18;
        this.add((Component)buttonPanel, gc);
        gc.gridx = 1;
        gc.fill = 1;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        gc.anchor = 10;
        this.add((Component)tablePanel, gc);
        if (this.presetHandler != null) {
            this.model.addTableModelListener(e -> this.updatePresets());
        }
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                TagEditorPanel.this.tagTable.requestFocusInCell(0, 0);
            }
        });
    }

    public TagEditorPanel(OsmPrimitive primitive, TaggingPresetHandler presetHandler) {
        this(new TagEditorModel().forPrimitive(primitive), presetHandler, 0);
    }

    public TagEditorPanel(TagEditorModel model, TaggingPresetHandler presetHandler, int maxCharacters) {
        this.model = model;
        this.presetHandler = presetHandler;
        if (this.model == null) {
            this.model = new TagEditorModel();
        }
        this.tagTable = new TagTable(this.model, maxCharacters);
        this.build();
    }

    public TagEditorModel getModel() {
        return this.model;
    }

    public void initAutoCompletion(OsmDataLayer layer) {
        CheckParameterUtil.ensureParameterNotNull(layer, "layer");
        AutoCompletionManager autocomplete = AutoCompletionManager.of(layer.data);
        AutoCompletionList acList = new AutoCompletionList();
        TagCellEditor editor = (TagCellEditor)this.tagTable.getColumnModel().getColumn(0).getCellEditor();
        editor.setAutoCompletionManager(autocomplete);
        editor.setAutoCompletionList(acList);
        editor = (TagCellEditor)this.tagTable.getColumnModel().getColumn(1).getCellEditor();
        editor.setAutoCompletionManager(autocomplete);
        editor.setAutoCompletionList(acList);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.tagTable.setEnabled(enabled);
        super.setEnabled(enabled);
    }

    private void updatePresets() {
        this.presetListPanel.updatePresets(this.model.getTaggingPresetTypes(), this.model.getTags(), this.presetHandler);
        this.validate();
    }
}

