/*
 * Decompiled with CFR 0.152.
 */
package uam;

import batching.Queue;
import batching.QueueItem;
import gui.UamGui;
import java.io.ByteArrayInputStream;
import shared.CryptHashes;
import shared.FileUtils;
import shared.Monitor;
import shared.b;
import shared.delegate;
import shared.m;
import shared.sevenzip;
import uam.InvisibleModal;
import uam.ThreadDownloader;
import uam.Uam;
import uam.UamConfigNew;

public class ThreadDownloadAndProcess
extends Thread {
    private static Queue queue;

    private static Queue getQueue() {
        if (queue == null) {
            queue = new Queue();
        }
        return queue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downloadConfig(String server, String potsfolder, delegate callback) {
        String server2 = server;
        String potsfolder2 = potsfolder;
        Queue queue = ThreadDownloadAndProcess.getQueue();
        try {
            UamConfigNew ageList;
            String file = server2 + "/" + "uam.status.xml";
            byte[] result = ThreadDownloader.downloadAsBytes(file);
            if (result == null) {
                boolean success = false;
                return;
            }
            if (potsfolder2 != null) {
                FileUtils.CreateFolder(potsfolder2 + "/agearchives/");
                if (FileUtils.HasFreeSpace(potsfolder2 + "/agearchives/", (long)result.length)) {
                    FileUtils.WriteFile(potsfolder2 + "/agearchives/" + "uam.status.xml", result);
                } else {
                    m.err("There isn't enough free space to save the Age list to disk.");
                }
            }
            ByteArrayInputStream in = new ByteArrayInputStream(result);
            Uam.ageList = ageList = new UamConfigNew(in);
            UamGui.RefreshInfo(potsfolder2);
            boolean success = true;
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public static void downloadAge(String age, String ver, String mir, String potsfolder, String whirlpool) {
        ThreadDownloadAndProcess.downloadOrExtractAge(age, ver, mir, potsfolder, whirlpool, true);
    }

    public static void downloadOrExtractAge(String age, String ver, String mir, String potsfolder, String whirlpool, boolean doDownload) {
        final String potsfolder2 = potsfolder;
        final String age2 = age;
        final String ver2 = ver;
        final String mir2 = mir;
        final String whirlpool2 = whirlpool;
        final boolean doDownload2 = doDownload;
        final Monitor trigger = new Monitor();
        ThreadDownloadAndProcess.getQueue().AddItem(new QueueItem(){
            boolean success;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                InvisibleModal modal = InvisibleModal.createAndShow();
                try {
                    String tempoutputfile;
                    String outputfolder = potsfolder2 + "/agearchives/";
                    FileUtils.CreateFolder(outputfolder);
                    String outputfile = outputfolder + age2 + "--" + ver2 + ".7z";
                    if (doDownload2 && !ThreadDownloader.downloadAsFile(mir2, tempoutputfile = outputfile)) {
                        FileUtils.DeleteFile(tempoutputfile);
                        this.success = false;
                        return;
                    }
                    m.status("Checking integrity...");
                    byte[] hash = CryptHashes.GetHash(outputfile, CryptHashes.Hashtype.sha1);
                    String hashstr = b.BytesToHexString(hash);
                    boolean isgood = whirlpool2.equals(hashstr);
                    if (!isgood) {
                        m.err("Bad file integrity. The Age downloaded wasn't what was expected, perhaps because the version on the server is corrupted.");
                        FileUtils.DeleteFile(outputfile);
                        this.success = false;
                        modal.hideInvisibleModal();
                        return;
                    }
                    m.status("File integrity is good!");
                    if (!sevenzip.extract(outputfile, potsfolder2)) {
                        this.success = false;
                        modal.hideInvisibleModal();
                        return;
                    }
                    m.status("Age installed!");
                    UamGui.RefreshInfo(potsfolder2);
                    this.success = true;
                }
                finally {
                    modal.hideInvisibleModal();
                    trigger.notifyCorrectly();
                }
            }
        });
        trigger.waitCorrectly();
    }

    public static void extractAge(String age, String ver, String potsfolder, String whirlpool) {
        ThreadDownloadAndProcess.downloadOrExtractAge(age, ver, null, potsfolder, whirlpool, false);
    }
}

