/*
 * Decompiled with CFR 0.152.
 */
package pythondec3.ast;

import pythondec3.ast.Ast;
import pythondec3.ast.Expr;
import pythondec3.ast.IList;
import pythondec3.ast.List;
import pythondec3.ast.Tok;
import pythondec3.ast.sgen;

public class Dsgn
extends Ast {
    public String toString() {
        return this.getGenString();
    }

    public static class Storeattr
    extends Dsgn {
        Ast obj;
        Tok token;

        public Storeattr(Ast obj, Tok token) {
            this.obj = obj;
            this.token = token;
        }

        @Override
        public void gen2(sgen s) {
            this.obj.gen(s);
            String name = this.token.getName(s);
            s.out(".");
            s.out(name);
        }
    }

    public static class Storename
    extends Dsgn {
        Tok token;

        public Storename(Ast token) {
            this.token = (Tok)token;
        }

        @Override
        public void gen2(sgen s) {
            String varname = this.token.getName(s);
            s.out(varname);
        }
    }

    public static class Storeglobal
    extends Dsgn {
        Tok token;

        public Storeglobal(Tok token) {
            this.token = token;
        }

        @Override
        public void gen2(sgen s) {
            String varname = this.token.getName(s);
            s.out(varname);
        }
    }

    public static class Storefast
    extends Dsgn {
        Tok token;

        public Storefast(Tok token) {
            this.token = token;
        }

        @Override
        public void gen2(sgen s) {
            String varname = this.token.getName(s);
            s.out(varname);
        }
    }

    public static class UnpackSequence
    extends Dsgn
    implements IList {
        List<Dsgn> desigs = new List();

        public List getlist() {
            return this.desigs;
        }

        @Override
        public void gen2(sgen s) {
            s.out("(");
            for (int i = 0; i < this.desigs.size(); ++i) {
                Dsgn desig = this.desigs.get(i);
                if (i != 0) {
                    s.out(", ");
                }
                desig.gen(s);
            }
            if (this.desigs.size() == 1) {
                s.out(",");
            }
            s.out(")");
        }
    }

    public static class Slice
    extends Dsgn {
        Ast obj;
        Ast left;
        Ast right;

        public Slice(Ast obj, Ast left, Ast right) {
            this.obj = obj;
            this.left = left;
            this.right = right;
        }

        @Override
        public void gen2(sgen s) {
            this.obj.gen(s);
            s.out("[");
            if (this.left != null) {
                this.left.gen(s);
            }
            s.out(":");
            if (this.right != null) {
                this.right.gen(s);
            }
            s.out("]");
        }
    }

    public static class Subscr
    extends Dsgn {
        Ast obj;
        Ast subscrindex;

        public Subscr(Ast obj, Ast subscrindex) {
            this.obj = obj;
            this.subscrindex = subscrindex;
        }

        @Override
        public void gen2(sgen s) {
            this.obj.gen(s);
            s.out("[");
            if (this.subscrindex instanceof Expr.Buildtuple) {
                Expr.Buildtuple bt2 = (Expr.Buildtuple)this.subscrindex;
                bt2.gen2NoParentheses(s);
            } else {
                this.subscrindex.gen(s);
            }
            s.out("]");
        }
    }

    public static class Attr
    extends Dsgn {
        Ast obj;
        Ast attrname;

        public Attr(Ast obj, Ast attrname) {
            this.obj = obj;
            this.attrname = attrname;
        }

        @Override
        public void gen2(sgen s) {
            this.obj.gen(s);
            s.out(".");
            this.attrname.gen(s);
        }
    }

    public static class Name
    extends Dsgn {
        Ast name;

        public Name(Ast name) {
            this.name = name;
        }

        @Override
        public void gen2(sgen s) {
            this.name.gen(s);
        }
    }
}

