/*
 * Decompiled with CFR 0.152.
 */
package lpg.runtime;

import lpg.runtime.ILexStream;
import lpg.runtime.IPrsStream;
import lpg.runtime.IToken;
import lpg.runtime.LexStream;
import lpg.runtime.MismatchedInputCharsException;
import lpg.runtime.UnknownStreamType;

public abstract class AbstractToken
implements IToken {
    private int kind = 0;
    private int startOffset = 0;
    private int endOffset = 0;
    private int tokenIndex = 0;
    private int adjunctIndex;
    private IPrsStream iPrsStream;

    public AbstractToken() {
    }

    public AbstractToken(IPrsStream iPrsStream, int startOffset, int endOffset, int kind) {
        this.iPrsStream = iPrsStream;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.kind = kind;
    }

    @Override
    public int getKind() {
        return this.kind;
    }

    @Override
    public void setKind(int kind) {
        this.kind = kind;
    }

    @Override
    public int getStartOffset() {
        return this.startOffset;
    }

    @Override
    public void setStartOffset(int startOffset) {
        this.startOffset = startOffset;
    }

    @Override
    public int getEndOffset() {
        return this.endOffset;
    }

    @Override
    public void setEndOffset(int endOffset) {
        this.endOffset = endOffset;
    }

    @Override
    public int getTokenIndex() {
        return this.tokenIndex;
    }

    @Override
    public void setTokenIndex(int tokenIndex) {
        this.tokenIndex = tokenIndex;
    }

    @Override
    public void setAdjunctIndex(int adjunctIndex) {
        this.adjunctIndex = adjunctIndex;
    }

    @Override
    public int getAdjunctIndex() {
        return this.adjunctIndex;
    }

    @Override
    public IPrsStream getIPrsStream() {
        return this.iPrsStream;
    }

    @Override
    public ILexStream getILexStream() {
        return this.iPrsStream == null ? null : this.iPrsStream.getILexStream();
    }

    @Override
    public int getLine() {
        return this.iPrsStream == null ? 0 : this.iPrsStream.getILexStream().getLineNumberOfCharAt(this.startOffset);
    }

    @Override
    public int getColumn() {
        return this.iPrsStream == null ? 0 : this.iPrsStream.getILexStream().getColumnOfCharAt(this.startOffset);
    }

    @Override
    public int getEndLine() {
        return this.iPrsStream == null ? 0 : this.iPrsStream.getILexStream().getLineNumberOfCharAt(this.endOffset);
    }

    @Override
    public int getEndColumn() {
        return this.iPrsStream == null ? 0 : this.iPrsStream.getILexStream().getColumnOfCharAt(this.endOffset);
    }

    @Override
    public IPrsStream getPrsStream() {
        return this.iPrsStream;
    }

    @Override
    public ILexStream getLexStream() {
        return this.iPrsStream == null ? null : this.iPrsStream.getILexStream();
    }

    @Override
    public String getValue(char[] inputChars) {
        if (this.iPrsStream != null) {
            return this.toString();
        }
        if (this.iPrsStream.getLexStream() instanceof LexStream) {
            LexStream lex_stream = (LexStream)this.iPrsStream.getLexStream();
            if (inputChars != lex_stream.getInputChars()) {
                throw new MismatchedInputCharsException();
            }
            return this.toString();
        }
        throw new UnknownStreamType("Unknown stream type " + this.iPrsStream.getLexStream().getClass().toString());
    }

    @Override
    public String toString() {
        return this.iPrsStream == null ? "<toString>" : this.iPrsStream.toString(this, this);
    }
}

