/*
 * Decompiled with CFR 0.152.
 */
package dust.com.sun.java.swing.plaf.motif;

import dust.com.sun.java.swing.plaf.motif.MotifScrollBarButton;
import dust.sun.swing.SwingUtilities2;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicScrollBarUI;

public class MotifScrollBarUI
extends BasicScrollBarUI {
    public static ComponentUI createUI(JComponent c) {
        return new MotifScrollBarUI();
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Insets insets = c.getInsets();
        int dx = insets.left + insets.right;
        int dy = insets.top + insets.bottom;
        return this.scrollbar.getOrientation() == 1 ? new Dimension(dx + 11, dy + 33) : new Dimension(dx + 33, dy + 11);
    }

    @Override
    protected JButton createDecreaseButton(int orientation) {
        return new MotifScrollBarButton(orientation);
    }

    @Override
    protected JButton createIncreaseButton(int orientation) {
        return new MotifScrollBarButton(orientation);
    }

    @Override
    public void paintTrack(Graphics g, JComponent c, Rectangle trackBounds) {
        g.setColor(this.trackColor);
        g.fillRect(trackBounds.x, trackBounds.y, trackBounds.width, trackBounds.height);
    }

    @Override
    public void paintThumb(Graphics g, JComponent c, Rectangle thumbBounds) {
        if (thumbBounds.isEmpty() || !this.scrollbar.isEnabled()) {
            return;
        }
        int w = thumbBounds.width;
        int h = thumbBounds.height;
        g.translate(thumbBounds.x, thumbBounds.y);
        g.setColor(this.thumbColor);
        g.fillRect(0, 0, w - 1, h - 1);
        g.setColor(this.thumbHighlightColor);
        SwingUtilities2.drawVLine(g, 0, 0, h - 1);
        SwingUtilities2.drawHLine(g, 1, w - 1, 0);
        g.setColor(this.thumbLightShadowColor);
        SwingUtilities2.drawHLine(g, 1, w - 1, h - 1);
        SwingUtilities2.drawVLine(g, w - 1, 1, h - 2);
        g.translate(-thumbBounds.x, -thumbBounds.y);
    }
}

