/*******************************************************************************
 * See COPYRIGHT.txt & LICENSE.txt for copyright and licensing details.
 *******************************************************************************/

#include "qfle3i.h"

/*
 *****************************************************************************
 *
 *  qfle3i_map_pci_mem --
 *
 *     Setup mapping of specified BAR and memory regions
 *
 *  Parameters:
 *     adapter: Pointer to driver qfle3i_adapter structure
 *     bar: PCI bar value
 *
 *  Results:
 *     VMK_ReturnStatus
 * 
 *  Side effects:
 *     None
 *
 *****************************************************************************
 */
/*
VMK_ReturnStatus 
qfle3i_map_pci_mem(struct qfle3i_adapter *adapter,
                  int bar,
		  vmk_VA *vaddr )
{
	VMK_ReturnStatus status = VMK_OK;
	vmk_VA vaAddr;

	status = vmk_PCIMapIOResource(vmk_ModuleCurrentID, adapter->pdev,
                                 bar, NULL, &vaAddr);
	if (status != VMK_OK) {
		vmk_WarningMessage("failed to map PCI resource (%s)\n",
			 vmk_StatusToString(status));
		return status;
	}

	*vaddr = vaAddr;

	return VMK_OK;  
}
*/
/*
 *******************************************************************************
 *
 *   qfle3i_unmap_pci_mem --
 *
 *      Cleanup the mapping of specified BAR and memory regions
 *
 *   Parameters:
 *      adapter: Pointer to driver qfle3i_adapter structure
 *      bar: PCI bar value
 *
 *   Results:
 *      VMK_ReturnStatus
 *
 *   Side effects:
 *      None
 *
 *******************************************************************************
 */
/*
VMK_ReturnStatus 
qfle3i_unmap_pci_mem(struct qfle3i_adapter *adapter,
                    int bar)
{
	VMK_ReturnStatus status = VMK_OK;

	status = vmk_PCIUnmapIOResource(vmk_ModuleCurrentID, adapter->pdev,
				   bar);
	if (status != VMK_OK) {
		vmk_WarningMessage("failed to unmap PCI resource (%s)\n",
			vmk_StatusToString(status));
		return status;
	}

	return VMK_OK;
}
*/
/*
 ******************************************************************************
 *
 * qfle3i_dma_map
 *
 *     Map a DMA element
 * 
 *  Parameters:
 *     
 *  Results:
 *    VMK_ReturnStatus
 *
 *  Side effects:
 *     None
 *
 ******************************************************************************
 */

VMK_ReturnStatus 
qfle3i_dma_map(vmk_DMAEngine dma_engine,
               vmk_DMADirection direction,
               vmk_MA ma,                 
               vmk_ByteCountSmall length,  
               vmk_IOA *ioa)               
{
	VMK_ReturnStatus status;
	vmk_SgElem in, out;
	vmk_DMAMapErrorInfo err_info;

	if (dma_engine == VMK_DMA_ENGINE_INVALID) {
		vmk_WarningMessage("DMA engine not initialized.");
		return VMK_BAD_PARAM;
	}

	if (ioa == NULL) {
		vmk_WarningMessage("Invalid I/O address.");
		return VMK_BAD_PARAM;
	}

	in.addr = ma;
	in.length = length;
	status = vmk_DMAMapElem(dma_engine, direction,
			&in, VMK_TRUE, &out, &err_info);
	if (status != VMK_OK) {
		if (status == VMK_DMA_MAPPING_FAILED) {
			vmk_WarningMessage("Failed to map machine address 0x%lx (%d): %s.",
					ma,length,
					vmk_DMAMapErrorReasonToString(err_info.reason));
		} else {
			vmk_WarningMessage("Failed to map machine address 0x%lx (%d): %s.",
					ma,length,
					vmk_StatusToString(status));
		}

		*ioa = 0;
		return status;
	}

	if (out.length != in.length) {
		vmk_WarningMessage("out.length != in.length.");
		return VMK_FAILURE;
	}

	*ioa = out.ioAddr;
	return VMK_OK;
}

/*
 ******************************************************************************
 *
 * qfle3i_dma_unmap
 * 
 *     Unmap a DMA location
 *
 *  Parameters:
 *     dma_engine: vmkernel dma engine
 *     direction: 
 *     ioa:
 *     length:
 *     
 *  Results:
 *     VMK_ReturnStatus
 *    
 *  Side effects:
 *     None
 *
 *******************************************************************************
*/

VMK_ReturnStatus
qfle3i_dma_unmap(vmk_DMAEngine dma_engine,    //IN
                 vmk_DMADirection direction, //IN
                 vmk_IOA ioa,                //IN
                 vmk_ByteCountSmall length)  //IN
{
	VMK_ReturnStatus status;
	vmk_SgElem in;

	in.ioAddr = ioa;
	in.length = length;

	status = vmk_DMAUnmapElem(dma_engine, direction, &in);
	if (status != VMK_OK) {
		vmk_WarningMessage("driver: Failed to unmap io address 0x%lx (%d): %s.",
			  ioa, length, vmk_StatusToString(status));
		return status;
	}
	return VMK_OK;
}
/*
 ******************************************************************************
 *
 * qfle3i_spin_lock_init
 *
 *     initialize vmk lock
 *
 *  Parameters:
 *     vmk_Lock *lock
 *
 *  Results:
 *     VMK_ReturnStatus
 * 
 *  Side effects:
 *     None
 *
 ******************************************************************************
 */
VMK_ReturnStatus qfle3i_spin_lock_init(vmk_Lock *lock)
{
	vmk_SpinlockCreateProps spinlock_props;
	VMK_ReturnStatus vmk_stat;
	vmk_Name module_name;

	vmk_Memset(&spinlock_props, 0, sizeof(spinlock_props));
	spinlock_props.moduleID = vmk_ModuleCurrentID;
	spinlock_props.heapID = vmk_ModuleGetHeapID(vmk_ModuleCurrentID);
	spinlock_props.domain = qfle3i_driver_info.lock_domain;
	spinlock_props.rank = QFLE3I_HIGH_LOCK_RANK;
	spinlock_props.type = VMK_SPINLOCK;

	vmk_stat = vmk_NameInitialize(&module_name, QFLE3I_DRIVER_NAME);
	if (vmk_stat != VMK_OK) {
		vmk_WarningMessage("%s failed", __func__);
		goto spin_lock_fail;
	}
	spinlock_props.name = module_name;

	vmk_stat = vmk_SpinlockCreate(&spinlock_props, lock);

	if (vmk_stat != VMK_OK) {
		vmk_WarningMessage("%s failed to create lock", __func__);
		goto spin_lock_fail;
	}

spin_lock_fail:
	return vmk_stat;
}

